/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.subr;

import java.util.List;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispNumber;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.Subr;
import net.morilib.lisp.subr.SubrUtils;

public class NumberToString
extends Subr {
    private Datum process(Datum d, int radix, LispMessage mesg) {
        if (d instanceof LispNumber) {
            try {
                return ((LispNumber)d).toLispString(radix);
            }
            catch (IllegalArgumentException e) {
                throw mesg.getError("err.notsupported.radix10");
            }
        }
        throw mesg.getError("err.require.number", d);
    }

    private Datum process(LispNumber d, int radix, int precision, LispMessage mesg) {
        try {
            return d.toLispString(radix, precision);
        }
        catch (IllegalArgumentException e) {
            throw mesg.getError("err.notsupported.radix10");
        }
    }

    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        List<Datum> lst = LispUtils.consToList(body, mesg);
        if (lst.size() == 1) {
            return this.process(lst.get(0), 10, mesg);
        }
        if (lst.size() == 2) {
            Datum d = lst.get(1);
            if (d instanceof LispNumber) {
                LispNumber n = (LispNumber)d;
                if (!n.isInteger()) {
                    throw mesg.getError("err.require.integer", n);
                }
                int ii = SubrUtils.getSmallInt(n, mesg);
                if (ii < 2 || ii > 16) {
                    throw mesg.getError("err.radix.invalid", d);
                }
                return this.process(lst.get(0), ii, mesg);
            }
            throw mesg.getError("err.require.integer", d);
        }
        if (lst.size() == 3) {
            LispNumber n = SubrUtils.getNumber(lst.get(0), mesg);
            int ii = SubrUtils.getSmallInt(lst.get(1), mesg);
            int p = SubrUtils.getSmallInt(lst.get(2), mesg);
            if (ii < 2 || ii > 16) {
                throw mesg.getError("err.radix.invalid", lst.get(1));
            }
            if (p < 0) {
                throw mesg.getError("err.require.int.nonnegative", lst.get(2));
            }
            return this.process(n, ii, p, mesg);
        }
        throw mesg.getError("err.argument", this.symbolName);
    }
}

