/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.r6rs.subr;

import java.math.BigInteger;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispReal;
import net.morilib.lisp.MultiValues;
import net.morilib.lisp.subr.BinaryArgs;

public class DivAndMod
extends BinaryArgs {
    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
        if (c1a instanceof LispReal && c2a instanceof LispReal) {
            LispReal r1 = (LispReal)c1a;
            LispReal r2 = (LispReal)c2a;
            if (r2.signum() == 0) {
                throw mesg.getError("err.divbyzero");
            }
            if (r1.isInteger() && r2.isInteger()) {
                void var6_15;
                void var5_12;
                BigInteger b;
                BigInteger a = r1.getBigInteger();
                BigInteger[] x = a.divideAndRemainder(b = r2.getBigInteger());
                if (x[1].signum() != 0 && a.signum() < 0) {
                    if (b.signum() > 0) {
                        x[0] = x[0].subtract(BigInteger.ONE);
                        x[1] = x[1].add(b);
                    } else {
                        x[0] = x[0].add(BigInteger.ONE);
                        x[1] = x[1].subtract(b);
                    }
                }
                LispInteger lispInteger = LispInteger.valueOf(x[0]);
                LispInteger lispInteger2 = LispInteger.valueOf(x[1]);
                if (r1.isExact() && r2.isExact()) return MultiValues.newValues(new Datum[]{var5_12, var6_15});
                LispReal lispReal = lispInteger.toInexact();
                LispReal lispReal2 = lispInteger2.toInexact();
                return MultiValues.newValues(new Datum[]{var5_12, var6_15});
            }
            if (r1.isInteger()) throw mesg.getError("err.require.int", r2);
            throw mesg.getError("err.require.int", r1);
        }
        if (c1a instanceof LispReal) throw mesg.getError("err.require.real", c2a);
        throw mesg.getError("err.require.real", c1a);
    }
}

