/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.r6rs.io.transcd;

import java.io.IOException;
import net.morilib.lisp.r6rs.io.transcd.AbstractOutputTranscoder;
import net.morilib.lisp.r6rs.io.transcd.OutputTranscoder;

public class BlockBufferedOutputTranscoder
extends AbstractOutputTranscoder {
    public static final int DEFAULT_BUFSIZE = 4096;
    protected OutputTranscoder tr;
    protected int[] buf;
    protected int count;

    public BlockBufferedOutputTranscoder(OutputTranscoder tr, int bufsize) {
        this.tr = tr;
        this.buf = new int[bufsize];
        this.count = 0;
    }

    public BlockBufferedOutputTranscoder(OutputTranscoder tr) {
        this(tr, 4096);
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.tr.close();
    }

    @Override
    public void write(int c) throws IOException {
        this.buf[this.count++] = c;
        if (this.count >= this.buf.length) {
            this.flush();
        }
    }

    @Override
    public void write(int[] b, int off, int len) throws IOException {
        int c2 = len;
        if (this.count + c2 < this.buf.length) {
            System.arraycopy(b, off, this.buf, this.count, len);
            this.count += len;
        } else {
            this.tr.write(this.buf, 0, this.count);
            this.tr.write(b, off, this.buf.length - this.count);
            int cp = this.buf.length - this.count;
            while (c2 - cp >= this.buf.length) {
                this.tr.write(b, off + cp, this.buf.length);
                cp += this.buf.length;
            }
            System.arraycopy(b, off + cp, this.buf, 0, c2 - cp);
            this.count = c2 - cp;
        }
    }

    @Override
    public void flush() throws IOException {
        this.tr.write(this.buf, 0, this.count);
        this.count = 0;
    }
}

