/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.r6rs.io;

import java.io.IOException;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispString;
import net.morilib.lisp.Parser;
import net.morilib.lisp.Procedure;
import net.morilib.lisp.ReadUnreadable;
import net.morilib.lisp.Scheme;
import net.morilib.lisp.r6rs.io.ILispTextualInputPort;
import net.morilib.lisp.r6rs.io.LispCustomInputPort;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.util.io.UTF16;

public class LispCustomTextualInputPort
extends LispCustomInputPort
implements ILispTextualInputPort,
ReadUnreadable {
    private Procedure read;
    private Parser parser;
    private int unread;

    public LispCustomTextualInputPort(Environment env, LispMessage mes, String id, Procedure rd, Procedure ps, Procedure sp, Procedure cl) {
        super(env, mes, id, ps, sp, cl);
        this.read = rd;
        this.parser = new Parser(this);
        this.unread = -1;
    }

    @Override
    public int getChar() throws IOException {
        if (this.unread >= 0) {
            this.lookahead = this.unread;
            return this.unread;
        }
        if (this.lookahead < 0) {
            return -1;
        }
        LispString b = new LispString(" ");
        Datum d = Scheme.callva(this.read, this.env, this.mesg, b, LispInteger.ZERO, LispInteger.ONE);
        int bts = SubrUtils.getSmallInt(d, this.mesg);
        int r = this.lookahead;
        if (bts > 0) {
            this.lookahead = b.get(0).getCharacterCodePoint();
            return r;
        }
        this.lookahead = -1;
        return -1;
    }

    @Override
    public int lookaheadChar() throws IOException {
        return this.unread >= 0 ? this.unread : this.lookahead;
    }

    @Override
    public String getString(int n) throws IOException {
        int[] r = new int[n];
        return this.getChars(r, 0, n) >= 0 ? UTF16.toString(r) : null;
    }

    @Override
    public int getChars(int[] buf, int start, int end) throws IOException {
        if (this.lookahead < 0) {
            return -1;
        }
        int t = this.unread < 0 ? 0 : 1;
        LispString b = new LispString(UTF16.toString(buf));
        Datum d = Scheme.callva(this.read, this.env, this.mesg, b, LispInteger.valueOf(start), LispInteger.valueOf(end - start - t));
        int bts = SubrUtils.getSmallInt(d, this.mesg);
        if (bts > 0) {
            int[] r = UTF16.getInts(b.getString());
            System.arraycopy(r, start, buf, start + 1 + t, bts - 1 - t);
            if (t > 0) {
                r[start] = this.unread;
                r[start + 1] = this.lookahead;
                this.unread = -1;
            } else {
                r[start] = this.lookahead;
            }
            this.lookahead = r[start + bts - 1 - t];
            return bts;
        }
        if (t > 0) {
            buf[start] = this.unread;
            buf[start + 1] = this.lookahead;
            this.lookahead = -1;
            this.unread = -1;
            return 2;
        }
        buf[start] = this.lookahead;
        this.lookahead = -1;
        return 1;
    }

    @Override
    public String getStringAll() throws IOException {
        int l;
        StringBuilder b = new StringBuilder();
        int[] c = new int[1024];
        while ((l = this.getChars(c, 0, 1024)) >= 0) {
            b.append(UTF16.toString(c, 0, l));
        }
        return b.toString();
    }

    @Override
    public String getLine() throws IOException {
        StringBuilder b = new StringBuilder();
        int c = 0;
        while ((c = this.getChar()) >= 0) {
            if (c == 10) break;
            b.appendCodePoint(c);
            ++c;
        }
        return b.toString();
    }

    @Override
    public Datum getDatum() throws IOException {
        return this.parser.parse() ? this.parser.getDatum() : null;
    }

    @Override
    public int getc() throws IOException {
        return this.getChar();
    }

    @Override
    public void unread(int c) {
        this.unread = c;
    }
}

