/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.r6rs.io;

import java.io.IOException;
import net.morilib.lisp.Datum;
import net.morilib.lisp.EOFObject;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispString;
import net.morilib.lisp.r6rs.io.ILispTextualInputPort;
import net.morilib.lisp.subr.QuaternaryArgs;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.util.io.UTF16;

public class GetStringNS
extends QuaternaryArgs {
    @Override
    protected Datum execute(Datum c1a, Datum c2a, Datum c3a, Datum c4a, Environment env, LispMessage mesg) {
        int st = SubrUtils.getSmallInt(c3a, mesg);
        int en = SubrUtils.getSmallInt(c4a, mesg) + st;
        if (!(c2a instanceof LispString)) {
            throw mesg.getError("err.require.string", c2a);
        }
        if (c1a instanceof ILispTextualInputPort) {
            try {
                int[] b = UTF16.getInts(c2a.getString());
                if (st < 0 || st >= b.length) {
                    throw mesg.getError("err.range.invalid");
                }
                if (en < 0 || en > b.length) {
                    throw mesg.getError("err.range.invalid");
                }
                if (st > en) {
                    throw mesg.getError("err.range.invalid");
                }
                int l = ((ILispTextualInputPort)((Object)c1a)).getChars(b, st, en);
                if (l < 0) {
                    return EOFObject.EOF;
                }
                ((LispString)c2a).setString(UTF16.toString(b));
                return LispInteger.valueOf(l);
            }
            catch (IOException e) {
                throw mesg.getError("err.io", e.getMessage());
            }
        }
        throw mesg.getError("err.io.require.port.textual.input", c1a);
    }
}

