/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.r6rs.bytevector;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Iterator;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Subr;
import net.morilib.lisp.r6rs.bytevector.LispBytevector;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.util.io.UTF8;
import net.morilib.util.string.StringIterator;

public class StringToUtf8
extends Subr {
    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ConsIterator itr = new ConsIterator(body);
        String s = SubrUtils.nextString((Iterator<Datum>)itr, mesg, body);
        int f = SubrUtils.nextSmallInt((Iterator<Datum>)itr, 0, mesg);
        int t = SubrUtils.nextSmallInt((Iterator<Datum>)itr, s.length(), mesg);
        SubrUtils.checkTerminated(itr, body, mesg);
        if (f < 0 || f > s.length()) {
            throw mesg.getError("err.range.invalid", f);
        }
        if (t < 0 || t > s.length()) {
            throw mesg.getError("err.range.invalid", t);
        }
        if (t < f) {
            throw mesg.getError("err.range.invalid");
        }
        StringIterator str = new StringIterator(s);
        while (str.hasNext()) {
            try {
                UTF8.write(bos, str.next());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return new LispBytevector(bos.toByteArray());
    }
}

