/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.r6rs.bytevector;

import java.util.Iterator;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Subr;
import net.morilib.lisp.Symbol;
import net.morilib.lisp.r6rs.bytevector.LispBytevector;
import net.morilib.lisp.r6rs.bytevector.SynEndianness;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.util.Endianness2;
import net.morilib.util.Iterators;
import net.morilib.util.string.StringIterator;

public class StringToUtf32
extends Subr {
    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        int t;
        int f;
        Endianness2 e;
        ConsIterator itr = new ConsIterator(body);
        String s = SubrUtils.nextString((Iterator<Datum>)itr, mesg, body);
        Datum d2 = Iterators.nextIf(itr);
        Datum d3 = Iterators.nextIf(itr);
        Datum d4 = Iterators.nextIf(itr);
        byte[] a = new byte[s.length() * 4];
        SubrUtils.checkTerminated(itr, body, mesg);
        if (d2 == null) {
            e = Endianness2.BIG;
            f = 0;
            t = s.length();
        } else {
            if (!(d2 instanceof Symbol)) {
                throw mesg.getError("err.r6rs.require.endianness", d2);
            }
            if (d3 == null) {
                e = SynEndianness.getEndianness(d2, mesg);
                f = 0;
                t = s.length();
            } else if (d4 == null) {
                e = SynEndianness.getEndianness(d2, mesg);
                f = SubrUtils.getSmallInt(d3, mesg);
                t = s.length();
            } else {
                e = SynEndianness.getEndianness(d2, mesg);
                f = SubrUtils.getSmallInt(d3, mesg);
                t = SubrUtils.getSmallInt(d4, mesg);
            }
        }
        if (f < 0 || f > s.length()) {
            throw mesg.getError("err.range.invalid", f);
        }
        if (t < 0 || t > s.length()) {
            throw mesg.getError("err.range.invalid", t);
        }
        if (t < f) {
            throw mesg.getError("err.range.invalid");
        }
        StringIterator str = new StringIterator(s);
        int k = 0;
        while (str.hasNext()) {
            e.write(a, k, 4, str.next());
            k += 4;
        }
        return new LispBytevector(a);
    }
}

