/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.painter.turtle;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import net.morilib.lisp.painter.drawer.CompositeDrawer;
import net.morilib.lisp.painter.drawer.CoordinateMap;
import net.morilib.lisp.painter.drawer.Drawer;
import net.morilib.lisp.painter.geom.MutablePoint2D;

public class TurtleDrawer
extends CompositeDrawer {
    private double tx;
    private double ty;
    private double tt = 0.0;
    private double stx;
    private double sty;
    private BufferedImage image;
    private ImageObserver obs;
    boolean show = true;

    public TurtleDrawer(double x, double y, BufferedImage img, ImageObserver obs) {
        super(new Drawer[0]);
        this.stx = this.tx = x;
        this.sty = this.ty = y;
        this.image = img;
        this.obs = obs;
    }

    public double getX() {
        return this.tx;
    }

    public double getY() {
        return this.ty;
    }

    public double getAngle() {
        return this.tt;
    }

    public void addTurnLeftByDegree(final double t) {
        this.add(new Drawer(){

            @Override
            public void draw(Graphics g, int framex, int framey, CoordinateMap coordinate) {
                TurtleDrawer.this.tt = Math.IEEEremainder(TurtleDrawer.this.tt + t, 360.0);
            }
        });
    }

    public void addTurnLeftByRadian(final double t) {
        this.add(new Drawer(){

            @Override
            public void draw(Graphics g, int framex, int framey, CoordinateMap coordinate) {
                TurtleDrawer.this.tt = Math.IEEEremainder(TurtleDrawer.this.tt + t * 180.0 / Math.PI, 360.0);
            }
        });
    }

    public void addDrawLine(final double r) {
        this.add(new Drawer(){

            @Override
            public void draw(Graphics g, int framex, int framey, CoordinateMap coordinate) {
                if (coordinate != null) {
                    double nx = TurtleDrawer.this.tx - r * Math.sin(TurtleDrawer.this.tt / 180.0 * Math.PI);
                    double ny = TurtleDrawer.this.ty + r * Math.cos(TurtleDrawer.this.tt / 180.0 * Math.PI);
                    MutablePoint2D p1 = coordinate.transform(framex, framey, TurtleDrawer.this.tx, TurtleDrawer.this.ty);
                    MutablePoint2D p2 = coordinate.transform(framex, framey, nx, ny);
                    g.drawLine(p1.getXInt(), p1.getYInt(), p2.getXInt(), p2.getYInt());
                    TurtleDrawer.this.tx = nx;
                    TurtleDrawer.this.ty = ny;
                } else {
                    double nx = TurtleDrawer.this.tx - r * Math.sin(TurtleDrawer.this.tt / 180.0 * Math.PI);
                    double ny = TurtleDrawer.this.ty + r * Math.cos(TurtleDrawer.this.tt / 180.0 * Math.PI);
                    g.drawLine((int)TurtleDrawer.this.tx, (int)TurtleDrawer.this.ty, (int)nx, (int)ny);
                    TurtleDrawer.this.tx = nx;
                    TurtleDrawer.this.ty = ny;
                }
            }
        });
    }

    public void addMove(final double r) {
        this.add(new Drawer(){

            @Override
            public void draw(Graphics g, int framex, int framey, CoordinateMap coordinate) {
                TurtleDrawer turtleDrawer = TurtleDrawer.this;
                turtleDrawer.tx = turtleDrawer.tx - r * Math.sin(TurtleDrawer.this.tt / 180.0 * Math.PI);
                TurtleDrawer turtleDrawer2 = TurtleDrawer.this;
                turtleDrawer2.ty = turtleDrawer2.ty + r * Math.cos(TurtleDrawer.this.tt / 180.0 * Math.PI);
            }
        });
    }

    public void addColor(final Color c) {
        this.add(new Drawer(){

            @Override
            public void draw(Graphics g, int framex, int framey, CoordinateMap coordinate) {
                g.setColor(c);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void draw(Graphics g, int framex, int framey, CoordinateMap coordinate) {
        MutablePoint2D p1 = coordinate.transform(framex, framey, this.tx, this.ty);
        this.tx = this.stx;
        this.ty = this.sty;
        this.tt = 0.0;
        TurtleDrawer turtleDrawer = this;
        synchronized (turtleDrawer) {
            for (Drawer d : this.drawers) {
                d.draw(g, framex, framey, coordinate);
            }
        }
        if (this.show) {
            AffineTransform rt = ((Graphics2D)g).getTransform();
            AffineTransform rr = AffineTransform.getTranslateInstance(p1.getX(), p1.getY());
            rr.rotate(-this.tt / 180.0 * Math.PI);
            rr.translate(-p1.getX(), -p1.getY());
            ((Graphics2D)g).setTransform(rr);
            g.drawImage(this.image, p1.getXInt() - this.image.getWidth() / 2, p1.getYInt() - this.image.getHeight() / 2, this.obs);
            ((Graphics2D)g).setTransform(rt);
        }
    }
}

