/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.math.sequence;

import net.morilib.lisp.LispDouble;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispReal;
import net.morilib.lisp.math.sequence.AbstractLispRealSequence;
import net.morilib.lisp.math.sequence.ILispRealSequence;
import net.morilib.lisp.math.sequence.ILispSequence;
import net.morilib.lisp.math.sequence.LispHarmonicSequence;
import net.morilib.lisp.math.sequence.LispRealConstantSequence;

public class LispArithmeticSequence
extends AbstractLispRealSequence {
    public static final int INFINITE = -1;
    private LispReal a1;
    private LispReal d;
    private int size;

    public LispArithmeticSequence(LispReal a1, LispReal d, int size) {
        if (a1 == null || d == null) {
            throw new NullPointerException();
        }
        if (d.signum() == 0) {
            throw new IllegalArgumentException();
        }
        if (size == 0) {
            throw new IllegalArgumentException();
        }
        this.a1 = a1;
        this.d = d;
        this.size = size;
    }

    @Override
    public LispReal get(int i) {
        if (i < 1) {
            throw new IndexOutOfBoundsException();
        }
        return this.a1.add((LispReal)this.d.multiply(i - 1));
    }

    @Override
    public LispReal limit() {
        if (this.size >= 1) {
            return LispInteger.ZERO;
        }
        if (this.d.signum() > 0) {
            return LispDouble.POSITIVE_INFINITY;
        }
        return LispDouble.NEGATIVE_INFINITY;
    }

    @Override
    public boolean isFinite() {
        return this.size >= 1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public ILispRealSequence difference() {
        return new LispRealConstantSequence(this.d, this.size >= 2 ? this.size - 1 : this.size);
    }

    @Override
    public ILispSequence inv() {
        return new LispHarmonicSequence((LispReal)this.a1.invert(), this.d.divide(this.a1), this.size);
    }

    @Override
    public LispReal sum(int start, int end) {
        if (start < 1) {
            throw new IllegalArgumentException();
        }
        if (end < 1) {
            throw new IllegalArgumentException();
        }
        if (start > end) {
            throw new IllegalArgumentException();
        }
        return ((LispReal)((LispReal)this.a1.multiply(2)).add((LispReal)this.d.multiply(end - start)).multiply(end - start + 1)).divide(LispInteger.valueOf(2));
    }

    @Override
    public LispReal sum() {
        if (this.size >= 1) {
            return this.sum(1, this.size());
        }
        if (this.d.signum() > 0) {
            return LispDouble.POSITIVE_INFINITY;
        }
        return LispDouble.NEGATIVE_INFINITY;
    }
}

