/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.math.matrix;

import java.io.Serializable;
import java.util.Arrays;
import net.morilib.lisp.Datum;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispNumber;
import net.morilib.lisp.math.matrix.AbstractImmutableLispMatrix;
import net.morilib.lisp.math.matrix.AbstractLispArrayMatrix;
import net.morilib.lisp.math.matrix.ILispMatrix;
import net.morilib.lisp.math.matrix.LispMatrices;
import net.morilib.lisp.math.matrix.LispMatrixException;

public class LispMatrix
extends AbstractLispArrayMatrix
implements Serializable {
    private LispNumber[] array;
    private transient AbstractImmutableLispMatrix[] decomposed = null;

    public LispMatrix(int rows, int columns) {
        this(rows, columns, LispInteger.ZERO);
    }

    public LispMatrix(int rows, int columns, LispNumber fill) {
        this.array = new LispNumber[rows * columns];
        this.rows = rows;
        this.columns = columns;
        Arrays.fill(this.array, fill);
    }

    public LispMatrix(LispMatrix m) {
        this.array = new LispNumber[m.rows * m.columns];
        this.rows = m.rows;
        this.columns = m.columns;
        System.arraycopy(m.array, 0, this.array, 0, this.array.length);
    }

    public LispMatrix(ILispMatrix m) {
        this.array = new LispNumber[m.rowSize() * m.columnSize()];
        this.rows = m.rowSize();
        this.columns = m.columnSize();
        int i = 0;
        while (i < m.rowSize()) {
            int j = 0;
            while (j < m.columnSize()) {
                this.set(i, j, m.get(i, j));
                ++j;
            }
            ++i;
        }
    }

    public static LispMatrix newElementMatrix(int size) {
        LispMatrix r = new LispMatrix(size, size);
        int i = 0;
        while (i < size) {
            r.set(i, i, LispInteger.ONE);
            ++i;
        }
        return r;
    }

    @Override
    protected LispNumber array(int index) {
        return this.array[index];
    }

    @Override
    protected void arrayset(int index, Datum x) {
        this.array[index] = (LispNumber)x;
    }

    @Override
    protected LispMatrix prototype() {
        return new LispMatrix(this.rows, this.columns);
    }

    @Override
    protected LispMatrix prototype(int rows, int columns) {
        return new LispMatrix(rows, columns);
    }

    @Override
    public LispMatrix clone() {
        return new LispMatrix(this);
    }

    @Override
    protected void arraycopy(int srcPos, Object dest, int destPos, int len) {
        System.arraycopy(this.array, srcPos, dest, destPos, len);
    }

    @Override
    public LispNumber determinant() throws LispMatrixException {
        if (this.columns != this.rows) {
            throw new LispMatrixException();
        }
        if (this.decomposed == null) {
            this.decomposed = LispMatrices.decomposeLU(this);
        }
        return this.decomposed[0].determinant().mul(this.decomposed[2].determinant());
    }

    @Override
    public ILispMatrix inv() throws LispMatrixException {
        if (this.columns != this.rows) {
            throw new LispMatrixException();
        }
        if (this.decomposed == null) {
            this.decomposed = LispMatrices.decomposeLU(this);
        }
        ILispMatrix x = this.decomposed[2].inv();
        ILispMatrix y = this.decomposed[1].inv();
        x = x.mul(y);
        y = this.decomposed[0].inv();
        x = x.mul(y);
        return x;
    }
}

