/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.iterator;

import java.util.NoSuchElementException;
import net.morilib.lisp.Cons;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispVector;
import net.morilib.lisp.iterator.ILispIterator;
import net.morilib.lisp.iterator.LispIteratorDatum;
import net.morilib.lisp.subr.UnaryArgs;
import net.morilib.util.ArrayListStack;
import net.morilib.util.Stack2;

public class MakeTreeWalker
extends UnaryArgs {
    private static void _w(Stack2<Datum> stk) {
        while (!stk.isEmpty()) {
            Datum d = stk.peek();
            if (d instanceof Cons) {
                stk.pop();
                stk.push(((Cons)d).getCdr());
                stk.push(((Cons)d).getCar());
                continue;
            }
            if (d instanceof LispVector) {
                stk.pop();
                int i = ((LispVector)d).size() - 1;
                while (i >= 0) {
                    stk.push(((LispVector)d).get(i));
                    --i;
                }
                continue;
            }
            if (!d.isNil()) break;
            stk.pop();
        }
    }

    @Override
    protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
        final ArrayListStack<Datum> stk = new ArrayListStack<Datum>();
        stk.push(c1a);
        MakeTreeWalker._w(stk);
        return new LispIteratorDatum(){

            @Override
            public boolean isTerminated() {
                return stk.isEmpty();
            }

            @Override
            public ILispIterator next() {
                stk.pop();
                MakeTreeWalker._w(stk);
                return this;
            }

            @Override
            public Datum getCurrentDatum() {
                if (stk.isEmpty()) {
                    throw new NoSuchElementException();
                }
                return (Datum)stk.peek();
            }

            @Override
            public void toDisplayString(StringBuilder buf) {
                buf.append("#<tree-walker>");
            }
        };
    }
}

