/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.games;

import net.morilib.games.TicTacToe;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.InputPort;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Subr;
import net.morilib.lisp.Symbol;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.util.Iterators;

public class PlayTicTacToe
extends Subr {
    private Datum play(boolean yourTurn, LispMessage mesg) {
        InputPort ip = InputPort.getStandard(mesg);
        boolean turn = true;
        int board = 0;
        while (!TicTacToe.isEven(board)) {
            if (yourTurn == turn) {
                int y;
                int x;
                System.out.print(TicTacToe.toString(board));
                while (true) {
                    System.out.print("x,y> ");
                    String s = ip.readLine();
                    String[] t = s.split(",");
                    if (t.length != 2) continue;
                    try {
                        x = Integer.parseInt(t[0].trim());
                        y = Integer.parseInt(t[1].trim());
                        if (x < 0 || x >= 3 || y < 0 || y >= 3) continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        continue;
                    }
                    break;
                }
                board = TicTacToe.put(board, x, y);
            } else {
                board = TicTacToe.think(board);
            }
            if (TicTacToe.isWin(board, yourTurn)) {
                return Symbol.getSymbol("you-win");
            }
            if (TicTacToe.isWin(board, !yourTurn)) {
                return Symbol.getSymbol("you-lose");
            }
            boolean bl = turn = !turn;
        }
        return Symbol.getSymbol("even");
    }

    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        ConsIterator itr = new ConsIterator(body);
        Datum d = Iterators.nextIf(itr);
        SubrUtils.checkTerminated(itr, body, mesg);
        boolean b = d == null ? Math.random() >= 0.5 : d.isTrue();
        return this.play(b, mesg);
    }
}

