/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.compare;

import java.util.Iterator;
import net.morilib.lisp.Cons;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Procedure;
import net.morilib.lisp.Subr;
import net.morilib.lisp.compare.SRFI67;
import net.morilib.lisp.subr.SubrUtils;

public class PairCompare
extends Subr {
    private LispInteger cmppair(Datum x, Datum y, Datum p, Environment env, LispMessage mesg) {
        if (x.isNil()) {
            return y.isNil() ? SRFI67.EQUAL : SRFI67.LESS;
        }
        if (x instanceof Cons) {
            if (y.isNil()) {
                return SRFI67.GREATER;
            }
            if (y instanceof Cons) {
                return SRFI67.callCompare(p, ((Cons)x).getCar(), ((Cons)y).getCar(), env, mesg);
            }
            return SRFI67.LESS;
        }
        if (y.isNil() || y instanceof Cons) {
            return SRFI67.GREATER;
        }
        return SRFI67.callCompare(p, x, y, env, mesg);
    }

    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        Datum y;
        Datum x;
        ConsIterator itr = new ConsIterator(body);
        Datum p = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
        Datum q = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
        if (p instanceof Procedure && q instanceof Procedure) {
            Datum x2 = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            Datum y2 = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            if (!(x2 instanceof Cons)) {
                throw mesg.getError("err.require.pair", x2);
            }
            if (!(y2 instanceof Cons)) {
                throw mesg.getError("err.require.pair", y2);
            }
            Cons cx = (Cons)x2;
            Cons cy = (Cons)y2;
            LispInteger c = SRFI67.callCompare(p, cx.getCar(), cy.getCar(), env, mesg);
            if (c.signum() == 0) {
                return SRFI67.callCompare(q, cx.getCdr(), cy.getCdr(), env, mesg);
            }
            return c;
        }
        if (p instanceof Procedure) {
            x = q;
            y = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
        } else {
            x = p;
            y = q;
            p = null;
        }
        ConsIterator ix = new ConsIterator(x);
        ConsIterator iy = new ConsIterator(y);
        while (ix.hasNext() && iy.hasNext()) {
            LispInteger c = this.cmppair(ix.next(), iy.next(), p, env, mesg);
            if (c.signum() == 0) continue;
            return c;
        }
        return this.cmppair(ix.rest(), iy.rest(), p, env, mesg);
    }
}

