/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.calendar;

import net.morilib.calendar.Day;
import net.morilib.calendar.SolarCalendar;
import net.morilib.calendar.WeekCalendar;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Datum2;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.math.algebra.ILispNumberEqual;

public class LispDay
extends Datum2
implements ILispNumberEqual<LispDay>,
Comparable<LispDay> {
    Day calendar;

    static Day getDay(Datum d, LispMessage mesg) {
        if (d instanceof LispDay) {
            return ((LispDay)d).calendar;
        }
        throw mesg.getError("err.calendar.require.day");
    }

    static SolarCalendar getSolarCalendar(Datum d, LispMessage mesg) {
        Day x;
        if (d instanceof LispDay && (x = ((LispDay)d).calendar) instanceof SolarCalendar) {
            return (SolarCalendar)x;
        }
        throw mesg.getError("err.calendar.require.solarcalendar");
    }

    static WeekCalendar getWeekCalendar(Datum d, LispMessage mesg) {
        Day x;
        if (d instanceof LispDay && (x = ((LispDay)d).calendar) instanceof WeekCalendar) {
            return (WeekCalendar)x;
        }
        throw mesg.getError("err.calendar.require.weekcalendar");
    }

    public LispDay(Day d) {
        this.calendar = d;
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        buf.append(this.calendar.toString());
    }

    @Override
    public int compareTo(LispDay o) {
        long b;
        long a = this.calendar.getDate();
        return a < (b = o.calendar.getDate()) ? -1 : (a > b ? 1 : 0);
    }

    @Override
    public boolean isEqualTo(LispDay x) {
        return this.calendar.getDate() == x.calendar.getDate();
    }
}

