/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.automata.trie;

import net.morilib.automata.trie.IntegerTrieBuilder;
import net.morilib.lisp.Cons;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Nil;
import net.morilib.lisp.Subr;
import net.morilib.lisp.automata.trie.LispStringTrie;
import net.morilib.lisp.subr.SubrUtils;

public class MakeStringTrie
extends Subr {
    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        ConsIterator itr = new ConsIterator(body);
        IntegerTrieBuilder<Nil> b = new IntegerTrieBuilder<Nil>();
        while (itr.hasNext()) {
            Datum x;
            String s;
            Datum d = itr.next();
            if (d instanceof Cons) {
                s = SubrUtils.getString(((Cons)d).getCar(), mesg);
                x = ((Cons)d).getCdr();
            } else {
                s = SubrUtils.getString(d, mesg);
                x = Nil.NIL;
            }
            if (s.isEmpty()) {
                throw mesg.getError("err.automata.notempty", s);
            }
            b.append(s, (Nil)x);
        }
        return new LispStringTrie(b.get());
    }
}

