/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.automata.nfa;

import java.util.ArrayList;
import net.morilib.automata.nfa.NFAAccept;
import net.morilib.automata.nfa.NFAAlternative;
import net.morilib.automata.nfa.NFAConcatenation;
import net.morilib.automata.nfa.NFAObject;
import net.morilib.automata.nfa.NFAOptional;
import net.morilib.automata.nfa.NFARepetition;
import net.morilib.automata.nfa.SingleObjectNFA;
import net.morilib.lisp.Cons;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Symbol;
import net.morilib.lisp.automata.nfa.LispNfa;
import net.morilib.lisp.subr.BinaryArgs;

public class MakeNfa
extends BinaryArgs {
    private static final Symbol ALT = Symbol.getSymbol("|");
    private static final Symbol CAT = Symbol.getSymbol("&");
    private static final Symbol OPT = Symbol.getSymbol("?");
    private static final Symbol RP0 = Symbol.getSymbol("*");
    private static final Symbol RP1 = Symbol.getSymbol("+");

    private static Datum getd(ConsIterator itr, LispMessage mesg) {
        if (itr.hasNext()) {
            Datum x = itr.next();
            if (itr.hasNext()) {
                throw mesg.getError("err.automata.regex.syntaxerror");
            }
            return x;
        }
        throw mesg.getError("err.automata.regex.syntaxerror");
    }

    static NFAObject<Datum, Datum, Datum> makeNFA(Datum d, LispMessage mesg) {
        if (d.isNil()) {
            throw mesg.getError("err.automata.regex.syntaxerror", d);
        }
        if (d instanceof Cons) {
            ConsIterator itr = new ConsIterator(d);
            Datum x = itr.next();
            if (x.equals(ALT)) {
                ArrayList l = new ArrayList();
                while (itr.hasNext()) {
                    l.add(MakeNfa.makeNFA(itr.next(), mesg));
                }
                return NFAAlternative.newInstance(l);
            }
            if (x.equals(CAT)) {
                ArrayList l = new ArrayList();
                while (itr.hasNext()) {
                    l.add(MakeNfa.makeNFA(itr.next(), mesg));
                }
                return NFAConcatenation.newInstance(l);
            }
            if (x.equals(OPT)) {
                return NFAOptional.newInstance(MakeNfa.makeNFA(MakeNfa.getd(itr, mesg), mesg));
            }
            if (x.equals(RP0)) {
                return NFARepetition.newInstance(MakeNfa.makeNFA(MakeNfa.getd(itr, mesg), mesg), true);
            }
            if (x.equals(RP1)) {
                return NFARepetition.newInstance(MakeNfa.makeNFA(MakeNfa.getd(itr, mesg), mesg), false);
            }
            ArrayList l = new ArrayList();
            l.add(MakeNfa.makeNFA(x, mesg));
            while (itr.hasNext()) {
                l.add(MakeNfa.makeNFA(itr.next(), mesg));
            }
            return NFAConcatenation.newInstance(l);
        }
        return SingleObjectNFA.newInstance(d);
    }

    @Override
    protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
        return new LispNfa(NFAAccept.newInstance(MakeNfa.makeNFA(c1a, mesg), c2a));
    }
}

