/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.automata.nfa;

import java.util.HashSet;
import java.util.Set;
import net.morilib.automata.NFAState;
import net.morilib.automata.nfa.NFAs;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Datum2;
import net.morilib.lisp.LispCharacter;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.automata.ILispConfiguration;
import net.morilib.lisp.automata.nfa.ILispNfa;
import net.morilib.lisp.automata.nfa.LispNfaState;

public class LispNfaStates
extends Datum2
implements ILispConfiguration {
    ILispNfa nfa;
    Set<NFAState> states;

    LispNfaStates(ILispNfa nfa, Set<NFAState> states) {
        this.nfa = nfa;
        this.states = states;
    }

    @Override
    public LispNfaStates go(Datum d, LispMessage mesg) {
        Set<NFAState> s = NFAs.getEpsilonReachable(this.nfa.getNFA(), this.states);
        return new LispNfaStates(this.nfa, NFAs.getStates(this.nfa.getNFA(), s, d));
    }

    @Override
    public LispNfaStates go(int d, LispMessage mesg) {
        return this.go(LispInteger.valueOf(d), mesg);
    }

    @Override
    public LispNfaStates go(char d, LispMessage mesg) {
        return this.go(LispCharacter.valueOf(d), mesg);
    }

    @Override
    public ILispConfiguration goSideEffect(Datum d, LispMessage mesg) {
        return this.go(d, mesg);
    }

    @Override
    public ILispConfiguration goSideEffect(int d, LispMessage mesg) {
        return this.go(d, mesg);
    }

    @Override
    public ILispConfiguration goSideEffect(char d, LispMessage mesg) {
        return this.go(d, mesg);
    }

    public Set<Datum> getStates() {
        HashSet<Datum> r = new HashSet<Datum>();
        for (NFAState s : this.states) {
            r.add(new LispNfaState(s));
        }
        return r;
    }

    @Override
    public boolean isAccepted() {
        Set<NFAState> s = NFAs.getEpsilonReachable(this.nfa.getNFA(), this.states);
        return NFAs.isAccepted(this.nfa.getNFA(), s);
    }

    @Override
    public boolean isInitialState() {
        Set<NFAState> s = NFAs.getEpsilonReachable(this.nfa.getNFA(), this.states);
        return NFAs.isInitialState(this.nfa.getNFA(), s);
    }

    @Override
    public boolean isDead() {
        return this.states.isEmpty();
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        buf.append("#<nfa-states>");
    }
}

