/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.automata.lr;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Datum2;
import net.morilib.lisp.automata.cfg.LispCFGRule;
import net.morilib.lisp.automata.lr.ILispLR1Goto;
import net.morilib.lisp.automata.lr.ILispLRTable;
import net.morilib.lisp.automata.lr.LispLR1Item;
import net.morilib.lisp.automata.lr.LispLR1Items;
import net.morilib.lisp.automata.lr.LispReduceReduceConflict;
import net.morilib.lisp.automata.lr.LispShiftReduceConflict;

public class LispLR1Table
extends Datum2
implements ILispLRTable {
    private Map<LispLR1Items, Map<Datum, LispLR1Items>> shift = new HashMap<LispLR1Items, Map<Datum, LispLR1Items>>();
    private Map<LispLR1Items, Map<Datum, Set<LispCFGRule>>> reduce = new HashMap<LispLR1Items, Map<Datum, Set<LispCFGRule>>>();
    private Map<LispLR1Items, Set<Datum>> accept = new HashMap<LispLR1Items, Set<Datum>>();
    private Map<LispLR1Items, Map<Datum, LispLR1Items>> ire = new HashMap<LispLR1Items, Map<Datum, LispLR1Items>>();
    private LispLR1Items init;
    private List<Datum> conflicts = new ArrayList<Datum>();

    private void addshift(LispLR1Items s, Datum a, LispLR1Items t) {
        Map<Datum, LispLR1Items> m;
        Set<LispCFGRule> z = this.getReduces(s, a);
        if (z != null) {
            LispCFGRule w = z.iterator().next();
            this.conflicts.add(new LispShiftReduceConflict(s, a, w));
        }
        if ((m = this.shift.get(s)) == null) {
            m = new HashMap<Datum, LispLR1Items>();
            this.shift.put(s, m);
        }
        m.put(a, t);
    }

    private void addgoto(LispLR1Items s, Datum a, LispLR1Items t) {
        Map<Datum, LispLR1Items> m = this.ire.get(s);
        if (m == null) {
            m = new HashMap<Datum, LispLR1Items>();
            this.ire.put(s, m);
        }
        m.put(a, t);
    }

    private void addreduce(LispLR1Items s, Datum a, LispCFGRule t) {
        Set<LispCFGRule> z;
        if (this.getShift(s, a) != null) {
            this.conflicts.add(new LispShiftReduceConflict(s, a, t));
        } else {
            z = this.getReduces(s, a);
            if (z != null && !z.isEmpty()) {
                LispCFGRule w = z.iterator().next();
                this.conflicts.add(new LispReduceReduceConflict(s, t, w));
            }
        }
        Map<Datum, Set<LispCFGRule>> m = this.reduce.get(s);
        if (m == null) {
            m = new HashMap<Datum, Set<LispCFGRule>>();
            this.reduce.put(s, m);
        }
        if ((z = m.get(a)) == null) {
            z = new HashSet<LispCFGRule>();
            m.put(a, z);
        }
        z.add(t);
    }

    private void addaccept(LispLR1Items s, Datum a) {
        Set<Datum> z = this.accept.get(s);
        if (z == null) {
            z = new HashSet<Datum>();
            this.accept.put(s, z);
        }
        z.add(a);
    }

    private void constr(ILispLR1Goto a) {
        for (LispLR1Items s : a.getAllStates()) {
            for (LispLR1Item t : s.getItems()) {
                Datum d = t.getIndicated();
                if (d == null) {
                    if (t.isAccepted(a.getCFG())) {
                        this.addaccept(s, t.getLookahead());
                        continue;
                    }
                    this.addreduce(s, t.getLookahead(), t.getRule());
                    continue;
                }
                if (!d.isGrammarVariable()) {
                    this.addshift(s, d, a.go(s, d));
                    continue;
                }
                this.addgoto(s, d, a.go(s, d));
            }
        }
    }

    public LispLR1Table(ILispLR1Goto lr1goto) {
        this.init = lr1goto.getInitialItems();
        this.constr(lr1goto);
        System.out.println(this.shift);
    }

    @Override
    public Datum getInitialState() {
        return this.init;
    }

    @Override
    public LispLR1Items getShift(Datum state, Datum alphabet) {
        Map<Datum, LispLR1Items> m = this.shift.get(state);
        return m == null ? null : m.get(alphabet);
    }

    @Override
    public Set<LispCFGRule> getReduces(Datum state, Datum alphabet) {
        Map<Datum, Set<LispCFGRule>> m = this.reduce.get(state);
        return m == null ? null : m.get(alphabet);
    }

    @Override
    public LispCFGRule getReduce(Datum state, Datum alphabet) {
        Set<LispCFGRule> s = this.getReduces(state, alphabet);
        return s == null || s.isEmpty() ? null : s.iterator().next();
    }

    @Override
    public boolean isAccept(Datum state, Datum alphabet) {
        Set<Datum> m = this.accept.get(state);
        return m != null && m.contains(alphabet);
    }

    @Override
    public Datum getGoto(Datum state, Datum variable) {
        Map<Datum, LispLR1Items> m = this.ire.get(state);
        return m == null ? null : m.get(variable);
    }

    @Override
    public List<Datum> getConflicts() {
        return Collections.unmodifiableList(this.conflicts);
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        buf.append("#<lr1-table>");
    }
}

