/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.automata.lr;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Datum2;
import net.morilib.lisp.automata.LispAutomataUtils;
import net.morilib.lisp.automata.LispGrammarVariable;
import net.morilib.lisp.automata.cfg.LispCFG;
import net.morilib.lisp.automata.cfg.LispCFGRule;
import net.morilib.lisp.automata.lr.LispLR0Automaton;
import net.morilib.lisp.automata.lr.LispLR0Item;
import net.morilib.lisp.automata.lr.LispLR0Items;
import net.morilib.lisp.automata.lr.LispLR1Item;

public class LispLR1Items
extends Datum2 {
    private static final Datum DUMMY = new Datum2(){

        @Override
        public void toDisplayString(StringBuilder buf) {
            buf.append("#<dummy-marker>");
        }
    };
    Set<LispLR1Item> items;

    public LispLR1Items(Collection<LispLR1Item> items) {
        this.items = new HashSet<LispLR1Item>(items);
    }

    public LispLR1Items(LispLR1Item ... items) {
        this(Arrays.asList(items));
    }

    public Set<LispLR1Item> getItems() {
        return Collections.unmodifiableSet(this.items);
    }

    public static Set<LispLR1Item> getKernelItems(LispCFG cfg, Set<LispLR1Item> items) {
        HashSet<LispLR1Item> s = new HashSet<LispLR1Item>();
        LispGrammarVariable st = cfg.getStartVariable();
        for (LispLR1Item i : items) {
            if (i.maybeKernel()) {
                s.add(i);
                continue;
            }
            if (!i.getLeftValue().equals(st)) continue;
            s.add(i);
        }
        return s;
    }

    public Set<LispLR1Item> getKernelItems(LispCFG cfg) {
        return LispLR1Items.getKernelItems(cfg, this.items);
    }

    public static Set<LispLR1Item> getClosure(LispCFG cfg, Set<LispLR1Item> si) {
        boolean c = true;
        while (c) {
            c = false;
            HashSet<LispLR1Item> sj = new HashSet<LispLR1Item>(si);
            for (LispLR1Item i : si) {
                Datum d = i.getIndicated();
                if (d == null) continue;
                for (LispCFGRule r : cfg.getRules()) {
                    if (!r.getLeftValue().equals(d)) continue;
                    ArrayList<Datum> l = new ArrayList<Datum>();
                    List<Datum> m = i.getRightValues();
                    int p = i.getMark() + 1;
                    if (p < m.size()) {
                        l.addAll(m.subList(p, m.size()));
                    }
                    l.add(i.getLookahead());
                    for (Datum x : cfg.getFirst(l)) {
                        c |= sj.add(new LispLR1Item(r, 0, x));
                    }
                }
            }
            si = sj;
        }
        return si;
    }

    public LispLR1Items getClosure(LispCFG cfg) {
        return new LispLR1Items(LispLR1Items.getClosure(cfg, this.items));
    }

    private static boolean putlok(Map<LispLR0Items, Set<LispLR1Item>> s, LispLR0Items i0, LispLR1Item i1) {
        Set<LispLR1Item> r = s.get(i0);
        if (r == null) {
            r = new HashSet<LispLR1Item>();
            s.put(i0, r);
        }
        return r.add(i1);
    }

    private static Set<LispLR1Item> getlok(Map<LispLR0Items, Set<LispLR1Item>> s, LispLR0Items i0) {
        Set<LispLR1Item> r = s.get(i0);
        if (r == null) {
            r = new HashSet<LispLR1Item>();
            s.put(i0, r);
        }
        return r;
    }

    public static Map<LispLR0Items, LispLR1Items> propergateLookahead(LispLR0Automaton lr0) {
        LispLR1Item a2;
        LispLR1Item a1;
        LispCFG cfg = lr0.cfg;
        boolean c = true;
        HashMap<LispLR0Items, Set<LispLR1Item>> rr = new HashMap<LispLR0Items, Set<LispLR1Item>>();
        LispLR0Items i0 = cfg.lr0Start();
        Set<Object> s1 = new HashSet<LispLR1Item>();
        for (LispLR0Item i : i0.getKernelItems(cfg)) {
            if (!i.getLeftValue().equals(cfg.getStartVariable())) continue;
            s1.add(new LispLR1Item(i, LispAutomataUtils.ENDMARKER));
        }
        rr.put(i0, s1);
        for (LispLR0Items is : lr0.graph.keySet()) {
            for (LispLR0Item i : is.getKernelItems(cfg)) {
                a1 = new LispLR1Item(i, DUMMY);
                s1 = LispLR1Items.getClosure(cfg, Collections.singleton(a1));
                for (LispLR1Item lispLR1Item : s1) {
                    if (lispLR1Item.getIndicated() == null || lispLR1Item.getLookahead() == DUMMY) continue;
                    i0 = lr0.go(is, lispLR1Item.getIndicated());
                    for (LispLR0Item k : i0.items) {
                        a2 = new LispLR1Item(k, lispLR1Item.getLookahead());
                        if (!a2.maybeKernel()) continue;
                        LispLR1Items.putlok(rr, i0, a2);
                    }
                }
            }
        }
        while (c) {
            c = false;
            for (LispLR0Items is : lr0.graph.keySet()) {
                for (LispLR0Item i : is.getKernelItems(cfg)) {
                    a1 = new LispLR1Item(i, DUMMY);
                    s1 = LispLR1Items.getClosure(cfg, Collections.singleton(a1));
                    for (LispLR1Item lispLR1Item : s1) {
                        if (lispLR1Item.getIndicated() == null || lispLR1Item.getLookahead() != DUMMY) continue;
                        i0 = lr0.go(is, lispLR1Item.getIndicated());
                        for (LispLR0Item k : i0.items) {
                            HashSet<LispLR1Item> s2 = new HashSet<LispLR1Item>(LispLR1Items.getlok(rr, is));
                            for (LispLR1Item l : s2) {
                                a2 = new LispLR1Item(k, l.getLookahead());
                                if (!a2.maybeKernel()) continue;
                                c |= LispLR1Items.putlok(rr, i0, a2);
                            }
                        }
                    }
                }
            }
        }
        HashMap<LispLR0Items, LispLR1Items> zz = new HashMap<LispLR0Items, LispLR1Items>();
        for (LispLR0Items z : rr.keySet()) {
            zz.put(z, new LispLR1Items(LispLR1Items.getKernelItems(cfg, (Set)rr.get(z))));
        }
        return zz;
    }

    public int hashCode() {
        return this.items.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof LispLR1Items) {
            return this.items.equals(((LispLR1Items)o).items);
        }
        return false;
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        String d = "";
        buf.append("{");
        for (LispLR1Item i : this.items) {
            buf.append(d).append(i);
            d = " ";
        }
        buf.append("}");
    }
}

