/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.automata.lr;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.morilib.automata.DFA;
import net.morilib.automata.DFAState;
import net.morilib.automata.TextBound;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Datum2;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.automata.ILispConfiguration;
import net.morilib.lisp.automata.cfg.LispCFG;
import net.morilib.lisp.automata.dfa.AbstractLispDatumDfa;
import net.morilib.lisp.automata.dfa.ILispDfaState;
import net.morilib.lisp.automata.dfa.LispDfaDeadState;
import net.morilib.lisp.automata.lr.ILispLRGoto;
import net.morilib.lisp.automata.lr.LispLR0Items;
import net.morilib.range.Interval;

public class LispLR0Automaton
extends AbstractLispDatumDfa
implements DFA<Datum, Datum, Datum>,
ILispLRGoto {
    LispCFG cfg;
    Map<LispLR0Items, Map<Datum, LispLR0Items>> graph;
    Map<LispLR0Items, St> states;

    public LispLR0Automaton(LispCFG cfg) {
        this.cfg = cfg;
        this.graph = cfg.lr0Graph();
        this.states = new HashMap<LispLR0Items, St>();
    }

    private synchronized St getinst(LispLR0Items is) {
        St s = this.states.get(is);
        if (s == null) {
            s = new St();
            s.items = is;
            this.states.put(is, s);
        }
        return s;
    }

    @Override
    public LispLR0Items go(Datum i, Datum x) {
        Map<Datum, LispLR0Items> m = this.graph.get(i);
        return m == null ? null : m.get(x);
    }

    @Override
    public DFA<Datum, ?, ?> getDFA() {
        return this;
    }

    @Override
    public DFAState<Datum, Datum, Datum> getInitialState() {
        return this.getinst(this.cfg.lr0Start());
    }

    @Override
    public ILispDfaState getInitial() {
        return this.getinst(this.cfg.lr0Start());
    }

    @Override
    public LispLR0Items getInitialItems() {
        return this.cfg.lr0Start();
    }

    @Override
    public Set<Datum> getAlphabets(Datum s) {
        Map<Datum, LispLR0Items> m = this.graph.get(s);
        return m == null ? Collections.emptySet() : m.keySet();
    }

    @Override
    public LispCFG getCFG() {
        return this.cfg;
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        buf.append("#<cfg-lr0-goto-automaton>");
    }

    private class St
    extends Datum2
    implements ILispDfaState,
    DFAState<Datum, Datum, Datum> {
        private LispLR0Items items;

        private St() {
        }

        @Override
        public DFAState<Datum, Datum, Datum> go(Datum alphabet) {
            LispLR0Items i = LispLR0Automaton.this.go(this.items, alphabet);
            return i != null ? LispLR0Automaton.this.getinst(i) : LispDfaDeadState.DEAD_STATE;
        }

        @Override
        public DFAState<Datum, Datum, Datum> goInt(int x) {
            return LispDfaDeadState.DEAD_STATE;
        }

        @Override
        public DFAState<Datum, Datum, Datum> goChar(char x) {
            return LispDfaDeadState.DEAD_STATE;
        }

        @Override
        public ILispDfaState go(Datum d, LispMessage mesg) {
            LispLR0Items i = LispLR0Automaton.this.go(this.items, d);
            return i != null ? LispLR0Automaton.this.getinst(i) : LispDfaDeadState.DEAD_STATE;
        }

        @Override
        public ILispDfaState go(int d, LispMessage mesg) {
            return LispDfaDeadState.DEAD_STATE;
        }

        @Override
        public ILispDfaState go(char d, LispMessage mesg) {
            return LispDfaDeadState.DEAD_STATE;
        }

        @Override
        public DFAState<Datum, Datum, Datum> goBound(TextBound bound) {
            return LispDfaDeadState.DEAD_STATE;
        }

        @Override
        public ILispConfiguration goSideEffect(Datum d, LispMessage mesg) {
            return this.go(d, mesg);
        }

        @Override
        public ILispConfiguration goSideEffect(int d, LispMessage mesg) {
            return this.go(d, mesg);
        }

        @Override
        public ILispConfiguration goSideEffect(char d, LispMessage mesg) {
            return this.go(d, mesg);
        }

        @Override
        public boolean isInitialState() {
            return this.items.isStart(LispLR0Automaton.this.cfg);
        }

        @Override
        public Set<Datum> getAccepted() {
            if (this.isAccepted()) {
                return Collections.singleton(LispBoolean.TRUE);
            }
            return Collections.emptySet();
        }

        @Override
        public boolean isDead() {
            return false;
        }

        @Override
        public boolean isAccepted() {
            return this.items.isAccepted(LispLR0Automaton.this.cfg);
        }

        @Override
        public Set<Datum> getAlphabets() {
            Map<Datum, LispLR0Items> m = LispLR0Automaton.this.graph.get(this.items);
            return m != null ? m.keySet() : Collections.emptySet();
        }

        @Override
        public void toDisplayString(StringBuilder buf) {
            buf.append("#<state: ").append(this.items).append(">");
        }

        @Override
        public Iterable<Interval> getAlphabetRanges() {
            HashSet<Interval> r = new HashSet<Interval>();
            for (Datum t : this.getAlphabets()) {
                r.add(Interval.newPoint(t));
            }
            return r;
        }
    }
}

