/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.automata.lr;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.morilib.automata.DFA;
import net.morilib.automata.DFAState;
import net.morilib.lisp.Datum;
import net.morilib.lisp.automata.cfg.LispCFG;
import net.morilib.lisp.automata.dfa.AbstractLispDatumDfa;
import net.morilib.lisp.automata.dfa.ILispDfaState;
import net.morilib.lisp.automata.lr.ILispLR1Goto;
import net.morilib.lisp.automata.lr.LispLR0Automaton;
import net.morilib.lisp.automata.lr.LispLR0Items;
import net.morilib.lisp.automata.lr.LispLR1Items;

public class LispLALR1Automaton
extends AbstractLispDatumDfa
implements DFA<Datum, Datum, Datum>,
ILispLR1Goto {
    LispCFG cfg;
    LispLR0Automaton lr0fa;
    Map<LispLR0Items, LispLR1Items> lookaheads;
    private transient Map<LispLR0Items, LispLR1Items> cache;
    private transient Map<LispLR1Items, LispLR0Items> reverse;

    public LispLALR1Automaton(LispCFG cfg) {
        this.cfg = cfg;
        this.lr0fa = new LispLR0Automaton(cfg);
        this.lookaheads = LispLR1Items.propergateLookahead(this.lr0fa);
        this.cache = new HashMap<LispLR0Items, LispLR1Items>();
        this.reverse = new HashMap<LispLR1Items, LispLR0Items>();
        for (LispLR0Items s : this.lookaheads.keySet()) {
            LispLR1Items h = this.cache.get(s);
            if (h == null) {
                h = this.lookaheads.get(s).getClosure(cfg);
                this.cache.put(s, h);
            }
            this.reverse.put(h, s);
        }
    }

    @Override
    public LispLR1Items go(Datum i, Datum x) {
        LispLR0Items s = this.lr0fa.go(this.reverse.get(i), x);
        if (s == null) {
            return null;
        }
        LispLR1Items h = this.cache.get(s);
        if (h == null) {
            h = this.lookaheads.get(s).getClosure(this.cfg);
            this.cache.put(s, h);
        }
        return h;
    }

    @Override
    public Set<LispLR1Items> getAllStates() {
        HashSet<LispLR1Items> r = new HashSet<LispLR1Items>();
        for (LispLR0Items s : this.lookaheads.keySet()) {
            LispLR1Items h = this.cache.get(s);
            if (h == null) {
                h = this.lookaheads.get(s).getClosure(this.cfg);
                this.cache.put(s, h);
            }
            r.add(h);
        }
        return r;
    }

    @Override
    public DFA<Datum, ?, ?> getDFA() {
        return this;
    }

    @Override
    public DFAState<Datum, Datum, Datum> getInitialState() {
        return this.lr0fa.getInitialState();
    }

    @Override
    public ILispDfaState getInitial() {
        return this.lr0fa.getInitial();
    }

    @Override
    public LispLR1Items getInitialItems() {
        LispLR0Items s = this.lr0fa.getInitialItems();
        LispLR1Items h = this.cache.get(s);
        if (h == null) {
            h = this.lookaheads.get(s).getClosure(this.cfg);
            this.cache.put(s, h);
        }
        return h;
    }

    @Override
    public Set<Datum> getAlphabets(Datum s) {
        LispLR0Items x = this.reverse.get(s);
        return x == null ? Collections.emptySet() : this.lr0fa.getAlphabets(x);
    }

    @Override
    public LispCFG getCFG() {
        return this.cfg;
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        buf.append("#<cfg-lalr1-goto-automaton>");
    }
}

