/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.automata.dfa;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.morilib.automata.DFA;
import net.morilib.automata.DFAState;
import net.morilib.automata.TextBound;
import net.morilib.automata.dfa.DFAs;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Datum2;
import net.morilib.lisp.LispCharacter;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.automata.ILispConfiguration;
import net.morilib.lisp.automata.dfa.AbstractLispDatumDfa;
import net.morilib.lisp.automata.dfa.ILispDfaState;
import net.morilib.range.Interval;

public class LispMooreMachine
extends AbstractLispDatumDfa
implements DFA<Datum, Datum, Datum> {
    final State DEAD = new State(Collections.<Datum, Datum>emptyMap());
    Map<Datum, State> map;
    State initial;

    LispMooreMachine() {
    }

    @Override
    public ILispDfaState getInitial() {
        return this.initial;
    }

    public DFA<Datum, Datum, ?> getDFA() {
        return this;
    }

    @Override
    public DFAState<Datum, Datum, Datum> getInitialState() {
        return this.initial;
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        buf.append("#<dfa-datum-state>");
    }

    class State
    extends Datum2
    implements ILispDfaState,
    DFAState<Datum, Datum, Datum> {
        private Map<Datum, Datum> edges;
        private boolean initial;
        private Datum accepted;

        State(Map<Datum, Datum> edges) {
            this.edges = edges;
            this.initial = false;
            this.accepted = null;
        }

        State(Map<Datum, Datum> edges, boolean init, Datum a) {
            this.edges = edges;
            this.initial = init;
            this.accepted = a;
        }

        public State go(Datum alphabet) {
            State s = LispMooreMachine.this.map.get(this.edges.get(alphabet));
            return s != null ? s : LispMooreMachine.this.DEAD;
        }

        public State goInt(int x) {
            return this.go(LispInteger.valueOf(x));
        }

        public State goChar(char x) {
            return this.go(LispCharacter.valueOf(x));
        }

        @Override
        public DFAState<Datum, Datum, Datum> goBound(TextBound bound) {
            return DFAs.deadState();
        }

        @Override
        public boolean isInitialState() {
            return this.initial;
        }

        @Override
        public Set<Datum> getAccepted() {
            return this.accepted != null ? Collections.singleton(this.accepted) : Collections.emptySet();
        }

        @Override
        public boolean isDead() {
            return this.edges.isEmpty();
        }

        @Override
        public boolean isAccepted() {
            return this.accepted != null;
        }

        @Override
        public Set<Datum> getAlphabets() {
            return this.edges.keySet();
        }

        @Override
        public ILispDfaState go(Datum d, LispMessage mesg) {
            return this.go(d);
        }

        @Override
        public ILispDfaState go(int d, LispMessage mesg) {
            return this.goInt(d);
        }

        @Override
        public ILispDfaState go(char d, LispMessage mesg) {
            return this.goChar(d);
        }

        @Override
        public ILispConfiguration goSideEffect(Datum d, LispMessage mesg) {
            return this.go(d, mesg);
        }

        @Override
        public ILispConfiguration goSideEffect(int d, LispMessage mesg) {
            return this.go(d, mesg);
        }

        @Override
        public ILispConfiguration goSideEffect(char d, LispMessage mesg) {
            return this.go(d, mesg);
        }

        @Override
        public void toDisplayString(StringBuilder buf) {
            buf.append("#<dfa-state-from-table>");
        }

        @Override
        public Iterable<Interval> getAlphabetRanges() {
            HashSet<Interval> r = new HashSet<Interval>();
            for (Datum t : this.getAlphabets()) {
                r.add(Interval.newPoint(t));
            }
            return r;
        }
    }
}

