/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.automata;

import java.util.HashMap;
import java.util.Map;
import net.morilib.automata.NFAState;
import net.morilib.lisp.Datum2;

public final class LispGrammarVariable
extends Datum2
implements NFAState {
    private static Map<String, LispGrammarVariable> instances = new HashMap<String, LispGrammarVariable>();
    private static int nowgennum = 1;
    private String name;
    private int gennum;

    private LispGrammarVariable(String name) {
        this.name = name;
        this.gennum = -1;
    }

    private LispGrammarVariable(int gennum) {
        this.name = null;
        this.gennum = gennum;
    }

    public static synchronized LispGrammarVariable genvar() {
        return new LispGrammarVariable(nowgennum++);
    }

    public static synchronized LispGrammarVariable getInstance(String name) {
        LispGrammarVariable v = instances.get(name);
        if (v == null) {
            v = new LispGrammarVariable(name);
            instances.put(name, v);
        }
        return v;
    }

    @Override
    public boolean isGrammarVariable() {
        return true;
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        if (this.name != null) {
            buf.append("<<").append(this.name).append(">>");
        } else {
            buf.append("<<#").append(this.gennum).append(">>");
        }
    }
}

