/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.automata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Datum2;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.automata.ILispFormalGrammarRule;

public class Lisp0GrammarRule
extends Datum2
implements ILispFormalGrammarRule {
    private List<Datum> lvalues;
    private List<Datum> rvalues;

    Lisp0GrammarRule(List<Datum> lvalues, List<Datum> rvalues, int dummy) {
        if (dummy == 1) {
            this.lvalues = new ArrayList<Datum>(lvalues);
            this.rvalues = rvalues;
        } else if (dummy == 2) {
            this.lvalues = lvalues;
            this.rvalues = new ArrayList<Datum>(rvalues);
        } else if (dummy == 3) {
            this.lvalues = lvalues;
            this.rvalues = rvalues;
        } else {
            this.lvalues = new ArrayList<Datum>(lvalues);
            this.rvalues = new ArrayList<Datum>(rvalues);
        }
    }

    Lisp0GrammarRule(List<Datum> lvalues, List<Datum> rvalues) {
        this.lvalues = new ArrayList<Datum>(lvalues);
        this.rvalues = new ArrayList<Datum>(rvalues);
    }

    @Override
    public List<Datum> getLeftValues() {
        return Collections.unmodifiableList(this.lvalues);
    }

    @Override
    public List<Datum> getRightValues() {
        return Collections.unmodifiableList(this.rvalues);
    }

    @Override
    public boolean isEpsilonRule() {
        return this.rvalues.size() == 0;
    }

    @Override
    public boolean isUnitRule() {
        return this.lvalues.size() == 1 && this.rvalues.size() == 1 && this.lvalues.get(0).isGrammarVariable() && this.rvalues.get(0).isGrammarVariable();
    }

    @Override
    public boolean isEquivalentRule(ILispFormalGrammarRule r) {
        return this.getLeftValues().equals(r.getLeftValues()) && this.getRightValues().equals(r.getRightValues());
    }

    public int hashCode() {
        int r = 17;
        r = (r + this.lvalues.hashCode()) * 37;
        return r + this.rvalues.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof Lisp0GrammarRule) {
            Lisp0GrammarRule r = (Lisp0GrammarRule)o;
            return this.lvalues.equals(r.lvalues) && this.rvalues.equals(r.rvalues);
        }
        return false;
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        String d = "";
        buf.append("#<");
        for (Datum x : this.lvalues) {
            buf.append(d).append(LispUtils.print(x));
            d = " ";
        }
        buf.append(" ->");
        for (Datum x : this.rvalues) {
            buf.append(" ").append(LispUtils.print(x));
        }
        buf.append(">");
    }
}

