/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import net.morilib.lisp.LispComplex;
import net.morilib.lisp.LispDouble;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispNumber;
import net.morilib.lisp.LispOctonion;
import net.morilib.lisp.LispQuaternionImpl;
import net.morilib.lisp.LispReal;
import net.morilib.lisp.LispString;
import net.morilib.lisp.LispUtils;

public abstract class LispQuaternion
extends LispOctonion {
    public static LispQuaternion newQuaternion(LispReal r, LispReal i, LispReal j, LispReal k) {
        if (r.isNaN() || i.isNaN() || j.isNaN() || k.isNaN()) {
            return LispDouble.NaN;
        }
        if (j.isZero() && k.isZero()) {
            return LispComplex.newComplex(r, i);
        }
        if (r.isNaN() || i.isNaN() || j.isNaN() || k.isNaN()) {
            return LispDouble.NaN;
        }
        if (r.isExact() && i.isExact() && j.isExact() && k.isExact()) {
            return new LispQuaternionImpl(r, i, j, k);
        }
        return new LispQuaternionImpl(r.toInexact(), i.toInexact(), j.toInexact(), k.toInexact());
    }

    public static LispQuaternion add(LispQuaternion a, LispQuaternion b) {
        LispReal[] aa = a.getImagsAsQuaternion();
        LispReal[] bb = b.getImagsAsQuaternion();
        return LispQuaternion.newQuaternion(a.getReal().add(b.getReal()), aa[0].add(bb[0]), aa[1].add(bb[1]), aa[2].add(bb[2]));
    }

    public static LispQuaternion sub(LispQuaternion a, LispQuaternion b) {
        LispReal[] aa = a.getImagsAsQuaternion();
        LispReal[] bb = b.getImagsAsQuaternion();
        return LispQuaternion.newQuaternion(a.getReal().subtract(b.getReal()), aa[0].subtract(bb[0]), aa[1].subtract(bb[1]), aa[2].subtract(bb[2]));
    }

    public static LispQuaternion mul(LispQuaternion a, LispQuaternion b) {
        LispReal[] aa = a.getImagsAsQuaternion();
        LispReal[] bb = b.getImagsAsQuaternion();
        LispReal a1 = a.getReal();
        LispReal b1 = aa[0];
        LispReal c1 = aa[1];
        LispReal d1 = aa[2];
        LispReal a2 = b.getReal();
        LispReal b2 = bb[0];
        LispReal c2 = bb[1];
        LispReal d2 = bb[2];
        LispReal r = a1.multiply(a2).subtract(b1.multiply(b2)).subtract(c1.multiply(c2)).subtract(d1.multiply(d2));
        LispReal i = a1.multiply(b2).add(b1.multiply(a2)).add(c1.multiply(d2)).subtract(d1.multiply(c2));
        LispReal j = a1.multiply(c2).subtract(b1.multiply(d2)).add(c1.multiply(a2)).add(d1.multiply(b2));
        LispReal k = a1.multiply(d2).add(b1.multiply(c2)).subtract(c1.multiply(b2)).add(d1.multiply(a2));
        return LispQuaternion.newQuaternion(r, i, j, k);
    }

    public static LispQuaternion div(LispQuaternion a, LispQuaternion b) {
        LispReal[] aa = a.getImagsAsQuaternion();
        LispReal[] bb = b.getImagsAsQuaternion();
        LispReal q0 = a.getReal();
        LispReal q1 = aa[0];
        LispReal q2 = aa[1];
        LispReal q3 = aa[2];
        LispReal r0 = b.getReal();
        LispReal r1 = bb[0];
        LispReal r2 = bb[1];
        LispReal r3 = bb[2];
        LispReal rs = r0.multiply(r0).add(r1.multiply(r1)).add(r2.multiply(r2)).add(r3.multiply(r3));
        LispReal r = r0.multiply(q0).add(r1.multiply(q1)).add(r2.multiply(q2)).add(r3.multiply(q3));
        LispReal i = r0.multiply(q1).subtract(r1.multiply(q0)).subtract(r2.multiply(q3)).add(r3.multiply(q2));
        LispReal j = r0.multiply(q2).add(r1.multiply(q3)).subtract(r2.multiply(q0)).subtract(r3.multiply(q1));
        LispReal k = r0.multiply(q3).subtract(r1.multiply(q2)).add(r2.multiply(q1)).subtract(r3.multiply(q0));
        r = r.divide(rs);
        i = i.divide(rs);
        j = j.divide(rs);
        k = k.divide(rs);
        return LispQuaternion.newQuaternion(r, i, j, k);
    }

    public LispComplex[] getComplexPair() {
        return new LispComplex[]{this.getComplexPairA(), this.getComplexPairB()};
    }

    abstract LispComplex getComplexPairA();

    abstract LispComplex getComplexPairB();

    @Override
    public abstract LispQuaternion uminus();

    @Override
    public abstract LispQuaternion conjugate();

    @Override
    public boolean isEqualTo(LispNumber x) {
        if (x instanceof LispQuaternion) {
            LispQuaternion q = (LispQuaternion)x;
            return this.getComplexPairA().isEqualTo(q.getComplexPairA()) && this.getComplexPairB().isEqualTo(q.getComplexPairB());
        }
        return super.isEqualTo(x);
    }

    @Override
    public abstract LispReal getReal();

    @Override
    public abstract double getRealDouble();

    @Override
    public LispReal[] getImagsAsQuaternion() {
        return this.getImags();
    }

    @Override
    public double[] getImagsDoubleAsQuaternion() {
        return this.getImagsDouble();
    }

    @Override
    public LispReal[] getImagsAsOctonion() {
        LispReal[] im = this.getImags();
        LispReal o = this.isExact() ? LispInteger.ZERO : new LispDouble(0.0);
        return new LispReal[]{im[0], im[1], im[2], o, o, o, o};
    }

    @Override
    public double[] getImagsDoubleAsOctonion() {
        double[] im = this.getImagsDouble();
        return new double[]{im[0], im[1], im[2], 0.0, 0.0, 0.0, 0.0};
    }

    @Override
    LispQuaternion getQuaternionPairA() {
        return this;
    }

    @Override
    LispQuaternion getQuaternionPairB() {
        return LispInteger.ZERO;
    }

    @Override
    public LispString toLispString(int radix) {
        StringBuilder b = new StringBuilder();
        if (radix < 2 || radix > 36) {
            throw new IndexOutOfBoundsException("radix is out of range");
        }
        if (radix != 10) {
            throw new IllegalArgumentException("radix except 10 is not supported");
        }
        LispReal re = this.getReal();
        LispReal[] ims = this.getImags();
        String si = ims[0].signum() > 0 && !ims[0].isInfinity() ? "+" : "";
        String sj = ims[1].signum() > 0 && !ims[1].isInfinity() ? "+" : "";
        String sk = ims[2].signum() > 0 && !ims[2].isInfinity() ? "+" : "";
        b.append(LispUtils.getResult(re));
        if (!ims[0].isZero()) {
            b.append(si).append(LispUtils.getResult(ims[0])).append("i");
        }
        if (!ims[1].isZero()) {
            b.append(sj).append(LispUtils.getResult(ims[1])).append("j");
        }
        if (!ims[2].isZero()) {
            b.append(sk).append(LispUtils.getResult(ims[2])).append("k");
        }
        return new LispString(b.toString());
    }

    @Override
    public LispString toLispString(int radix, int precision) {
        StringBuilder b = new StringBuilder();
        if (radix < 2 || radix > 36) {
            throw new IndexOutOfBoundsException("radix is out of range");
        }
        if (radix != 10) {
            throw new IllegalArgumentException("radix except 10 is not supported");
        }
        if (precision < 0) {
            throw new IllegalArgumentException("precision must not be negative");
        }
        LispReal re = this.getReal();
        LispReal[] ims = this.getImags();
        String si = ims[0].signum() > 0 && !ims[0].isInfinity() ? "+" : "";
        String sj = ims[1].signum() > 0 && !ims[1].isInfinity() ? "+" : "";
        String sk = ims[2].signum() > 0 && !ims[2].isInfinity() ? "+" : "";
        b.append(LispUtils.getResult(re));
        if (!ims[0].isZero()) {
            b.append(si).append(ims[0].toLispString(radix, precision).getString()).append("i");
        }
        if (!ims[1].isZero()) {
            b.append(sj).append(ims[1].toLispString(radix, precision).getString()).append("j");
        }
        if (!ims[2].isZero()) {
            b.append(sk).append(ims[2].toLispString(radix, precision).getString()).append("k");
        }
        return new LispString(b.toString());
    }

    @Override
    public String print() {
        return this.getResult();
    }

    @Override
    public String getResult() {
        return this.toLispString(10).getString();
    }

    @Override
    public abstract LispQuaternion toExact();

    @Override
    public abstract LispQuaternion toInexact();
}

