/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lingua.numeral;

public final class IonianNumeral {
    private static String CENT = "\u0000\u03c1\u03c3\u03c4\u03c5\u03c6\u03c7\u03c8\u03c9\u03e1";
    private static String DECA = "\u0000\u03b9\u03ba\u03bb\u03bc\u03bd\u03be\u03bf\u03c0\u03d9";
    private static String UNUS = "\u0000\u03b1\u03b2\u03b3\u03b4\u03b5\u03db\u03b6\u03b7\u03b8";

    private IonianNumeral() {
    }

    public static String toGreek(int n) {
        StringBuffer r = new StringBuffer();
        if (n <= 0 || n >= 10000) {
            return null;
        }
        int m = n / 1000;
        int c = n / 100 % 10;
        int d = n / 10 % 10;
        int u = n % 10;
        if (m > 0) {
            r.append(',').append(UNUS.charAt(m));
        }
        if (c > 0) {
            r.append(CENT.charAt(c));
        }
        if (d > 0) {
            r.append(DECA.charAt(d));
        }
        if (u > 0) {
            r.append(UNUS.charAt(u));
        }
        return r.append('\'').toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int parse(String greek) {
        String s = greek.toLowerCase();
        int r = 0;
        int p = 0;
        while (true) {
            int i;
            int w;
            int n = w = p < s.length() ? (int)s.charAt(p) : -1;
            if (r == 0 && w == 44) {
                r = -10000;
            } else if (r == -10000 && (i = UNUS.indexOf(w)) > 0) {
                r = 1000 * i;
            } else {
                if (r < 0) {
                    if (w != -1) return -1;
                    int n2 = -r;
                    return n2;
                }
                if (r % 1000 == 0) {
                    i = CENT.indexOf(w);
                    if (i > 0) {
                        r += 100 * i;
                    } else {
                        i = DECA.indexOf(w);
                        if (i > 0) {
                            r += 10 * i;
                        } else {
                            i = UNUS.indexOf(w);
                            if (i > 0) {
                                r += i;
                            } else {
                                if (w != 39) return -1;
                                r = -r;
                            }
                        }
                    }
                } else if (r % 100 == 0) {
                    i = DECA.indexOf(w);
                    if (i > 0) {
                        r += 10 * i;
                    } else {
                        i = UNUS.indexOf(w);
                        if (i > 0) {
                            r += i;
                        } else {
                            if (w != 39) return -1;
                            r = -r;
                        }
                    }
                } else if (r % 10 == 0) {
                    i = UNUS.indexOf(w);
                    if (i > 0) {
                        r += i;
                    } else {
                        if (w != 39) return -1;
                        r = -r;
                    }
                } else {
                    if (w != 39) return -1;
                    r = -r;
                }
            }
            ++p;
        }
    }
}

