/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lingua;

public class LanguageTDBRecord {
    private static int R_ISO3 = 0;
    private static int R_ISO2B = 3;
    private static int R_ISO2A = 6;
    private static int R_ISO1 = 9;
    private static int R_SCOPE = 11;
    private static int R_LANG_TYPE = 12;
    private static int R_DESC = 13;
    private static int L_ISO3 = R_ISO2B - R_ISO3;
    private static int L_ISO2B = R_ISO2A - R_ISO2B;
    private static int L_ISO2A = R_ISO1 - R_ISO2A;
    private static int L_ISO1 = R_SCOPE - R_ISO1;
    private byte[] record;

    LanguageTDBRecord(byte[] record) {
        this.record = record;
    }

    public String getISO3() {
        return new String(this.record, R_ISO3, L_ISO3);
    }

    public String getISO2b() {
        return this.record[R_ISO2B] != 0 ? new String(this.record, R_ISO2B, L_ISO2B) : null;
    }

    public String getISO2a() {
        return this.record[R_ISO2A] != 0 ? new String(this.record, R_ISO2A, L_ISO2A) : null;
    }

    public String getISO1() {
        return this.record[R_ISO1] != 0 ? new String(this.record, R_ISO1, L_ISO1) : null;
    }

    public boolean isIndividual() {
        return (char)this.record[R_SCOPE] == 'I';
    }

    public boolean isMacrolanguage() {
        return (char)this.record[R_SCOPE] == 'M';
    }

    public boolean isSpecial() {
        return (char)this.record[R_SCOPE] == 'S';
    }

    public Scope getScope() {
        switch ((char)this.record[R_SCOPE]) {
            case 'I': {
                return Scope.INDIVIDUAL;
            }
            case 'M': {
                return Scope.MACROLANGUAGE;
            }
            case 'S': {
                return Scope.SPECIAL;
            }
        }
        throw new RuntimeException();
    }

    public boolean isAncient() {
        return (char)this.record[R_LANG_TYPE] == 'A';
    }

    public boolean isConstructed() {
        return (char)this.record[R_LANG_TYPE] == 'C';
    }

    public boolean isExtinct() {
        return (char)this.record[R_LANG_TYPE] == 'E';
    }

    public boolean isHistorical() {
        return (char)this.record[R_LANG_TYPE] == 'H';
    }

    public boolean isLiving() {
        return (char)this.record[R_LANG_TYPE] == 'L';
    }

    public Type getLanguageType() {
        switch ((char)this.record[R_LANG_TYPE]) {
            case 'A': {
                return Type.ANCIENT;
            }
            case 'C': {
                return Type.CONSTRUCTED;
            }
            case 'E': {
                return Type.EXTINCT;
            }
            case 'H': {
                return Type.HISTORICAL;
            }
            case 'L': {
                return Type.LIVING;
            }
            case 'S': {
                return Type.SPECIAL;
            }
        }
        throw new RuntimeException();
    }

    public String getDescription() {
        StringBuffer b = new StringBuffer();
        int i = R_DESC;
        while (this.record[i] != 0) {
            b.append((char)this.record[i]);
            ++i;
        }
        return b.toString();
    }

    public static enum Scope {
        INDIVIDUAL,
        MACROLANGUAGE,
        SPECIAL;

    }

    public static enum Type {
        ANCIENT,
        CONSTRUCTED,
        EXTINCT,
        HISTORICAL,
        LIVING,
        SPECIAL;

    }
}

