/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lingua;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.util.SortedMap;
import java.util.TreeMap;
import net.morilib.lingua.Language;
import net.morilib.lingua.LanguageTDBRecord;

public class LanguageTDB {
    static int RECORD_LEN = 96;
    private static final String DB_FILE = "/net/morilib/lingua/iso639.bin";
    private static final String ISO_FILE = "/net/morilib/lingua/iso639.properties";
    private static final int[] ISO_TAB;
    private static final SortedMap<String, String> ISO_MR;
    private static final int NIL = 675;
    private static File tmpfile;

    static {
        tmpfile = null;
        TreeMap<String, String> m = new TreeMap<String, String>();
        BufferedReader rd = null;
        try {
            try {
                rd = new BufferedReader(new InputStreamReader(Language.class.getResourceAsStream(ISO_FILE)));
                String s = LanguageTDB.skipcm(rd);
                if (s == null) {
                    throw new RuntimeException("missing lines");
                }
                int n = Integer.parseInt(s);
                int[] t = new int[n];
                int i = 0;
                while (i < n) {
                    s = LanguageTDB.skipcm(rd);
                    if (s == null) {
                        throw new RuntimeException();
                    }
                    t[i] = LanguageTDB.encodeISO639_3(s.toLowerCase());
                    if (s.length() == 6) {
                        String[] a = s.split("=");
                        m.put(a[1], a[0]);
                    }
                    ++i;
                }
                ISO_TAB = t;
                ISO_MR = m;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        catch (Throwable throwable) {
            LanguageTDB.closeq(rd);
            throw throwable;
        }
        LanguageTDB.closeq(rd);
    }

    private static void closeq(Closeable c) {
        try {
            if (c != null) {
                c.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static int val(String s, int i) {
        char c = s.charAt(i);
        if (c < 'a' || c > 'z') {
            throw new RuntimeException();
        }
        return c - 97;
    }

    static int encodeISO639_3(String s) {
        int x = 0;
        if (s.length() == 3) {
            x = LanguageTDB.val(s, 0);
            x = x * 26 + LanguageTDB.val(s, 1);
            return (x * 26 + LanguageTDB.val(s, 2)) * 26 * 26 + 675;
        }
        if (s.length() == 6 && s.charAt(3) == '=') {
            x = LanguageTDB.val(s, 0);
            x = x * 26 + LanguageTDB.val(s, 1);
            x = x * 26 + LanguageTDB.val(s, 2);
            x = x * 26 + LanguageTDB.val(s, 4);
            return x * 26 + LanguageTDB.val(s, 5);
        }
        throw new RuntimeException();
    }

    private static String skipcm(BufferedReader rd) throws IOException {
        String s;
        while ((s = rd.readLine()) != null && s.startsWith("#")) {
        }
        return s;
    }

    private static int getk(int i) {
        return ISO_TAB[i] / 26 / 26;
    }

    private static int getv(int i) {
        return ISO_TAB[i] % 676;
    }

    private static int srch(int k, int b, int e) {
        if (b == e) {
            return LanguageTDB.getk(b) == k ? b : -1;
        }
        int x = (b + e) / 2;
        return k <= LanguageTDB.getk(x) ? LanguageTDB.srch(k, b, x) : LanguageTDB.srch(k, x + 1, e);
    }

    static int searchIndex(int k) {
        return LanguageTDB.srch(k, 0, ISO_TAB.length - 1);
    }

    static String find(int k) {
        char[] a = new char[2];
        int x = LanguageTDB.searchIndex(k);
        if (x < 0) {
            return null;
        }
        if ((x = LanguageTDB.getv(x)) == 675) {
            return "";
        }
        a[0] = (char)(x / 26 + 97);
        a[1] = (char)(x % 26 + 97);
        return new String(a);
    }

    public static String findISO639_3(String s) {
        if (s.length() != 3) {
            return null;
        }
        return LanguageTDB.find(LanguageTDB.encodeISO639_3(s) / 26 / 26);
    }

    public static String findISO639_1(String s) {
        return (String)ISO_MR.get(s);
    }

    private static synchronized File initdb() throws IOException {
        BufferedInputStream r = null;
        BufferedOutputStream w = null;
        byte[] b = new byte[4096];
        if (tmpfile == null) {
            tmpfile = File.createTempFile("iso639", ".tmp");
            tmpfile.deleteOnExit();
            try {
                int l;
                r = new BufferedInputStream(Language.class.getResourceAsStream(DB_FILE));
                w = new BufferedOutputStream(new FileOutputStream(tmpfile));
                while ((l = r.read(b)) >= 0) {
                    w.write(b, 0, l);
                }
            }
            catch (Throwable throwable) {
                LanguageTDB.closeq(r);
                LanguageTDB.closeq(w);
                throw throwable;
            }
            LanguageTDB.closeq(r);
            LanguageTDB.closeq(w);
        }
        return tmpfile;
    }

    static LanguageTDBRecord getRecord(int i) {
        LanguageTDBRecord languageTDBRecord;
        byte[] b = new byte[RECORD_LEN];
        RandomAccessFile a = null;
        try {
            a = new RandomAccessFile(LanguageTDB.initdb(), "r");
            a.seek(i * RECORD_LEN);
            a.read(b);
            languageTDBRecord = new LanguageTDBRecord(b);
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                LanguageTDB.closeq(a);
                throw throwable;
            }
        }
        LanguageTDB.closeq(a);
        return languageTDBRecord;
    }

    static LanguageTDBRecord findRecord(int k) {
        int i = LanguageTDB.searchIndex(k);
        return i < 0 ? null : LanguageTDB.getRecord(i);
    }

    public static LanguageTDBRecord findRecord(String s) {
        if (s.length() != 3) {
            return null;
        }
        return LanguageTDB.findRecord(LanguageTDB.encodeISO639_3(s) / 26 / 26);
    }
}

