/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lingua;

import java.util.HashMap;
import java.util.Map;
import net.morilib.lingua.LanguageTDB;
import net.morilib.lingua.LanguageTDBRecord;

public class Language {
    private static final Map<String, Language> INSTANCES = new HashMap<String, Language>();
    private int code;

    private Language(int c) {
        this.code = c;
    }

    public static Language getInstance(String s) {
        if (s == null) {
            throw new NullPointerException();
        }
        String x = s.toLowerCase();
        Language l = INSTANCES.get(x);
        if (l != null) {
            return l;
        }
        if (x.length() == 3) {
            l = new Language(LanguageTDB.encodeISO639_3(x) / 26 / 26);
        } else if (x.length() == 2 && (x = LanguageTDB.findISO639_1(x)) != null) {
            l = Language.getInstance(x);
        } else {
            throw new IllegalArgumentException();
        }
        INSTANCES.put(s, l);
        return l;
    }

    public boolean isISO639_3() {
        return LanguageTDB.find(this.code) != null;
    }

    public String getISO639_1() {
        String s = LanguageTDB.find(this.code);
        return s != null && !s.equals("") ? s : null;
    }

    public LanguageTDBRecord getProperty() {
        return LanguageTDB.findRecord(this.code);
    }

    public String getName() {
        LanguageTDBRecord r = this.getProperty();
        return r != null ? r.getDescription() : null;
    }

    public String toString() {
        char[] a = new char[]{(char)(this.code / 26 / 26 + 97), (char)(this.code % 676 / 26 + 97), (char)(this.code % 26 + 97)};
        return new String(a);
    }
}

