/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lingua;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class FrenchUtils {
    private static final String IRREGULAR_NOUNS_FILE = "/net/morilib/lingua/french_irregular_nouns.properties";
    private static final Properties IRREGULAR_NOUNS;

    static {
        InputStream ins = FrenchUtils.class.getResourceAsStream(IRREGULAR_NOUNS_FILE);
        Properties p = new Properties();
        try {
            try {
                p.load(ins);
                IRREGULAR_NOUNS = p;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            try {
                ins.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static String toPlural(String word) {
        if (word == null) {
            throw new NullPointerException();
        }
        if (word.equals("")) {
            return word;
        }
        String s = IRREGULAR_NOUNS.getProperty(word);
        if (s != null) {
            return s;
        }
        if (word.endsWith("s") || word.endsWith("x") || word.endsWith("z")) {
            return word;
        }
        if (word.endsWith("au") || word.endsWith("eu") || word.endsWith("ou")) {
            return String.valueOf(word) + "x";
        }
        if (word.endsWith("al")) {
            return word.replaceFirst("al$", "aux");
        }
        return String.valueOf(word) + "s";
    }
}

