/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lang;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import net.morilib.lang.BCDDecimal;
import net.morilib.lang.BCDInteger;
import net.morilib.lang.BCDNaturalNumber;
import net.morilib.lang.Decimal32;

public final class Decimal64
extends Number
implements Comparable<Decimal64>,
Serializable {
    private static final long SGNMASK = Long.MIN_VALUE;
    private static final long SIGMASK = 287104476244869120L;
    private static final int EXPBIT = 50;
    private static final long CMBMASK = 0x7C00000000000000L;
    private static final int CMBBIT = 58;
    private static final int FRCSIZE = 15;
    private static final int EXPSIZE = 8;
    private static final int BIAS = 383;
    private static final long TBIT = 0x6000000000000000L;
    public static int MAX_EXPONENT = 384;
    public static int MIN_NORMALIZED_EXPONENT = -383;
    public static int MIN_EXPONENT = -398;
    public static long ZERO_BY_LONG = 0L;
    public static long MINUS_ZERO_BY_LONG = Long.MIN_VALUE;
    public static long POSITIVE_INFINITY_BY_LONG = 0x7800000000000000L;
    public static long NEGATIVE_INFINITY_BY_LONG = -576460752303423488L;
    public static long NaN_BY_LONG = 0x7C00000000000000L;
    private long value;

    public Decimal64(long value) {
        this.value = value;
    }

    public static int getExponentField(long x) {
        int e = (int)((x & 0x3FC000000000000L) >> 50);
        int c = (int)((x & 0x7C00000000000000L) >> 58);
        if (c < 24) {
            return e | (c & 0x18) << 5;
        }
        return e | (c & 6) << 7;
    }

    public static int getCombinationField(long x) {
        return (int)((x & 0x7C00000000000000L) >> 58);
    }

    static void writedpd(int p, byte[] b, int o) {
        if ((p & 8) == 0) {
            b[o + 0] = (byte)(p & 7);
            b[o + 1] = (byte)((p & 0x70) >> 4);
            b[o + 2] = (byte)((p & 0x380) >> 7);
        } else if ((p & 0xE) == 8) {
            b[o + 0] = (byte)((p & 1) + 8);
            b[o + 1] = (byte)((p & 0x70) >> 4);
            b[o + 2] = (byte)((p & 0x380) >> 7);
        } else if ((p & 0xE) == 10) {
            b[o + 0] = (byte)((p & 0x60) >> 4 | p & 1);
            b[o + 1] = (byte)(((p & 0x10) >> 4) + 8);
            b[o + 2] = (byte)((p & 0x380) >> 7);
        } else if ((p & 0xE) == 12) {
            b[o + 0] = (byte)((p & 0x300) >> 7 | p & 1);
            b[o + 1] = (byte)((p & 0x70) >> 4);
            b[o + 2] = (byte)(((p & 0x80) >> 7) + 8);
        } else if ((p & 0x60) == 64) {
            b[o + 0] = (byte)((p & 1) + 8);
            b[o + 1] = (byte)(((p & 0x10) >> 4) + 8);
            b[o + 2] = (byte)((p & 0x380) >> 7);
        } else if ((p & 0x60) == 32) {
            b[o + 0] = (byte)((p & 1) + 8);
            b[o + 1] = (byte)((p & 0x300) >> 7 | (p & 0x10) >> 4);
            b[o + 2] = (byte)(((p & 0x80) >> 7) + 8);
        } else if ((p & 0x60) == 0) {
            b[o + 0] = (byte)((p & 0x300) >> 7 | p & 1);
            b[o + 1] = (byte)(((p & 0x10) >> 4) + 8);
            b[o + 2] = (byte)(((p & 0x80) >> 7) + 8);
        } else {
            b[o + 0] = (byte)((p & 1) + 8);
            b[o + 1] = (byte)(((p & 0x10) >> 4) + 8);
            b[o + 2] = (byte)(((p & 0x80) >> 7) + 8);
        }
    }

    public static BCDDecimal getFractionField(long x) {
        byte[] b = new byte[16];
        int c = (int)((x & 0x7C00000000000000L) >> 58);
        Decimal64.writedpd((int)(x & 0x3FFL), b, 0);
        Decimal64.writedpd((int)(x >> 10 & 0x3FFL), b, 3);
        Decimal64.writedpd((int)(x >> 20 & 0x3FFL), b, 6);
        Decimal64.writedpd((int)(x >> 30 & 0x3FFL), b, 9);
        Decimal64.writedpd((int)(x >> 40 & 0x3FFL), b, 12);
        b[15] = (x & 0x6000000000000000L) == 0x6000000000000000L ? (byte)(8 | c & 1) : (byte)(c & 7);
        return new BCDDecimal(new BCDInteger(1, new BCDNaturalNumber(b)), 15);
    }

    public static boolean isZero(long x) {
        return (x & Long.MAX_VALUE) == 0L;
    }

    public static boolean isInfinite(long x) {
        return Decimal64.getCombinationField(x) == 30;
    }

    public static boolean isNaN(long x) {
        return Decimal64.getCombinationField(x) == 31;
    }

    static boolean isNormalized(long x) {
        return (x & 0x7C00000000000000L) != 0L;
    }

    public static int getSignum(long x) {
        return Decimal64.isZero(x) ? 0 : ((x & Long.MIN_VALUE) == 0L ? 1 : -1);
    }

    public static int getSignumExact(long x) {
        return (x & Long.MIN_VALUE) == 0L ? 1 : -1;
    }

    public static int getExponent(long x) {
        int e = Decimal64.getExponentField(x);
        if (Decimal64.isZero(x)) {
            return Integer.MIN_VALUE;
        }
        if (Decimal64.isNaN(x)) {
            return Integer.MAX_VALUE;
        }
        if (Decimal64.isInfinite(x)) {
            return 0x7FFFFFFE;
        }
        if (e > 0) {
            return e - 383;
        }
        return MIN_NORMALIZED_EXPONENT + Decimal64.getFractionField(x).getMostSignificantDigit();
    }

    static long encodedec1(BCDDecimal d, int p) {
        int r = 0;
        if (d.getDigit(p + 2) < 8) {
            if (d.getDigit(p + 1) < 8) {
                if (d.getDigit(p) < 8) {
                    r |= d.getDigit(p);
                    r |= d.getDigit(p + 1) << 4;
                    r |= d.getDigit(p + 2) << 7;
                } else {
                    r |= d.getDigit(p);
                    r |= d.getDigit(p + 1) << 4;
                    r |= d.getDigit(p + 2) << 7;
                }
            } else if (d.getDigit(p) < 8) {
                r |= 0xA;
                r |= d.getDigit(p) & 1;
                r |= (d.getDigit(p) & 6) << 4;
                r |= (d.getDigit(p + 1) & 1) << 4;
                r |= d.getDigit(p + 2) << 7;
            } else {
                r |= 0x4E;
                r |= d.getDigit(p) & 1;
                r |= (d.getDigit(p + 1) & 1) << 4;
                r |= d.getDigit(p + 2) << 7;
            }
        } else if (d.getDigit(p + 1) < 8) {
            if (d.getDigit(p) < 8) {
                r |= 0xC;
                r |= d.getDigit(p) & 1;
                r |= (d.getDigit(p) & 6) << 7;
                r |= d.getDigit(p + 1) << 4;
                r |= (d.getDigit(p + 2) & 1) << 7;
            } else {
                r |= 0x2E;
                r |= d.getDigit(p) & 1;
                r |= (d.getDigit(p + 1) & 1) << 4;
                r |= (d.getDigit(p + 1) & 6) << 7;
                r |= (d.getDigit(p + 2) & 1) << 7;
            }
        } else if (d.getDigit(p) < 8) {
            r |= 0xE;
            r |= d.getDigit(p) & 1;
            r |= (d.getDigit(p) & 6) << 7;
            r |= (d.getDigit(p + 1) & 1) << 4;
            r |= (d.getDigit(p + 2) & 1) << 7;
        } else {
            r |= 0x6E;
            r |= d.getDigit(p) & 1;
            r |= (d.getDigit(p + 1) & 1) << 4;
            r |= (d.getDigit(p + 2) & 1) << 7;
        }
        return r;
    }

    static long encodeDecimal(BCDDecimal d, int p) {
        long r = 0L;
        r |= Decimal64.encodedec1(d, p - 15);
        r |= Decimal64.encodedec1(d, p - 12) << 10;
        r |= Decimal64.encodedec1(d, p - 9) << 20;
        r |= Decimal64.encodedec1(d, p - 6) << 30;
        r |= Decimal64.encodedec1(d, p - 3) << 40;
        if (d.getDigit(p) < 8) {
            r |= (long)d.getDigit(p) << 58;
            r |= (long)(p + 383 & 0xFF) << 50;
            r |= (long)(p + 383 & 0x300) << 53;
        } else {
            r |= (long)(d.getDigit(p) & 1) << 58;
            r |= 0x6000000000000000L;
            r |= (long)(p + 383 & 0xFF) << 50;
            r |= (long)(p + 383 & 0x300) << 51;
        }
        return r;
    }

    public static long toDecimal(BCDDecimal dd) {
        long r;
        int md = dd.getMostSignificantDigit();
        if (dd.isZero()) {
            return ZERO_BY_LONG;
        }
        if (md < MIN_EXPONENT) {
            r = ZERO_BY_LONG;
        } else if (md < MIN_NORMALIZED_EXPONENT) {
            dd = dd.round(-MIN_EXPONENT);
            r = Decimal64.encodeDecimal(dd, MIN_NORMALIZED_EXPONENT);
        } else if (md <= MAX_EXPONENT) {
            dd = dd.round(-(md - 15));
            r = Decimal64.encodeDecimal(dd, md);
        } else {
            r = POSITIVE_INFINITY_BY_LONG;
        }
        if (dd.signum() < 0) {
            r |= Long.MIN_VALUE;
        }
        return r;
    }

    public static long parseDecimal(String s) {
        if (s == null) {
            throw new NullPointerException();
        }
        if (s.equalsIgnoreCase("NaN")) {
            return NaN_BY_LONG;
        }
        if (s.equalsIgnoreCase("Infinity")) {
            return POSITIVE_INFINITY_BY_LONG;
        }
        if (s.equalsIgnoreCase("+Infinity")) {
            return POSITIVE_INFINITY_BY_LONG;
        }
        if (s.equalsIgnoreCase("-Infinity")) {
            return NEGATIVE_INFINITY_BY_LONG;
        }
        return Decimal64.toDecimal(BCDDecimal.parseBCD(s));
    }

    public static BCDDecimal toBCDDecimal(long d) {
        BCDDecimal f = Decimal64.getFractionField(d);
        int e = Decimal64.getExponentField(d) - 383;
        if (Decimal64.getSignum(d) < 0) {
            f = f.negate();
        }
        if (Decimal64.isNaN(d) || Decimal64.isInfinite(d)) {
            return null;
        }
        if (e < MIN_NORMALIZED_EXPONENT) {
            return f.shift(MIN_NORMALIZED_EXPONENT);
        }
        return f.shift(e);
    }

    public static long toDecimal(double x) {
        if (Double.isNaN(x)) {
            return NaN_BY_LONG;
        }
        if (x == Double.POSITIVE_INFINITY) {
            return POSITIVE_INFINITY_BY_LONG;
        }
        if (x == Double.NEGATIVE_INFINITY) {
            return NEGATIVE_INFINITY_BY_LONG;
        }
        if (Double.doubleToLongBits(x) == 0L) {
            return ZERO_BY_LONG;
        }
        if (Double.doubleToLongBits(x) == Long.MIN_VALUE) {
            return MINUS_ZERO_BY_LONG;
        }
        return Decimal64.parseDecimal(Double.toString(x));
    }

    public static long add(long a, long b) {
        if (Decimal64.isNaN(a) || Decimal64.isNaN(b)) {
            return NaN_BY_LONG;
        }
        if (Decimal64.isInfinite(a)) {
            if (Decimal64.isInfinite(b)) {
                return Decimal64.getSignum(a) * Decimal64.getSignum(b) > 0 ? a : NaN_BY_LONG;
            }
            return a;
        }
        if (Decimal64.isInfinite(b)) {
            return b;
        }
        return Decimal64.toDecimal(Decimal64.toBCDDecimal(a).add(Decimal64.toBCDDecimal(b)));
    }

    public static long subtract(long a, long b) {
        if (Decimal64.isNaN(a) || Decimal64.isNaN(b)) {
            return NaN_BY_LONG;
        }
        if (Decimal64.isInfinite(a)) {
            if (Decimal64.isInfinite(b)) {
                return Decimal64.getSignum(a) * Decimal64.getSignum(b) < 0 ? a : NaN_BY_LONG;
            }
            return a;
        }
        if (Decimal64.isInfinite(b)) {
            return b ^ Long.MIN_VALUE;
        }
        return Decimal64.toDecimal(Decimal64.toBCDDecimal(a).subtract(Decimal64.toBCDDecimal(b)));
    }

    public static long multiply(long a, long b) {
        if (Decimal64.isNaN(a) || Decimal64.isNaN(b)) {
            return NaN_BY_LONG;
        }
        if (Decimal64.isInfinite(a) || Decimal64.isInfinite(b)) {
            switch (Decimal64.getSignum(a) * Decimal64.getSignum(b)) {
                case 1: {
                    return POSITIVE_INFINITY_BY_LONG;
                }
                case 0: {
                    return ZERO_BY_LONG;
                }
                case -1: {
                    return NEGATIVE_INFINITY_BY_LONG;
                }
            }
            throw new RuntimeException();
        }
        return Decimal64.toDecimal(Decimal64.toBCDDecimal(a).multiply(Decimal64.toBCDDecimal(b)));
    }

    public static long divide(long a, long b) {
        if (Decimal64.isNaN(a) || Decimal64.isNaN(b)) {
            return NaN_BY_LONG;
        }
        if (Decimal64.isZero(b)) {
            if (Decimal64.isZero(a)) {
                return NaN_BY_LONG;
            }
            if (Decimal64.getSignumExact(a) * Decimal64.getSignumExact(b) > 0) {
                return POSITIVE_INFINITY_BY_LONG;
            }
            return NEGATIVE_INFINITY_BY_LONG;
        }
        if (Decimal64.isInfinite(a)) {
            if (Decimal64.isInfinite(b)) {
                return NaN_BY_LONG;
            }
            if (Decimal64.getSignumExact(a) * Decimal64.getSignumExact(b) > 0) {
                return ZERO_BY_LONG;
            }
            return MINUS_ZERO_BY_LONG;
        }
        if (Decimal64.isInfinite(b)) {
            if (Decimal64.getSignumExact(a) * Decimal64.getSignumExact(b) > 0) {
                return ZERO_BY_LONG;
            }
            return MINUS_ZERO_BY_LONG;
        }
        BCDDecimal da = Decimal64.toBCDDecimal(a).shiftExtend(17);
        BCDDecimal db = Decimal64.toBCDDecimal(b);
        BCDDecimal dc = da.divide(db);
        return Decimal64.toDecimal(dc);
    }

    public static long negate(long l) {
        return l ^ Long.MIN_VALUE;
    }

    public static long toDecimal(long l) {
        return Decimal64.toDecimal(BCDDecimal.valueOf(l, 0));
    }

    public static BigDecimal toBigDecimal(long l) {
        if (Decimal64.isNaN(l) || Decimal64.isInfinite(l)) {
            throw new IllegalArgumentException();
        }
        if (Decimal64.isZero(l)) {
            return BigDecimal.ZERO;
        }
        if (Decimal64.isNormalized(l)) {
            int e = Decimal64.getExponent(l);
            BigDecimal d = Decimal64.getFractionField(l).toBigDecimal();
            return d.setScale(e + 15, RoundingMode.HALF_EVEN);
        }
        BigDecimal d = Decimal64.getFractionField(l).toBigDecimal();
        return d.setScale(-MIN_EXPONENT, RoundingMode.HALF_EVEN);
    }

    public static int toInt(long l) {
        return Decimal64.toBigDecimal(l).intValue();
    }

    public static long toLong(long l) {
        return Decimal64.toBigDecimal(l).longValue();
    }

    public static long round(long l, int digit) {
        BCDDecimal d;
        int e = Decimal64.getExponent(l);
        if (Decimal64.isNaN(l) || Decimal64.isInfinite(l) || Decimal64.isZero(l)) {
            return l;
        }
        if (-digit > e + 1) {
            return ZERO_BY_LONG;
        }
        if (-digit == e + 1) {
            d = Decimal64.getFractionField(l);
            if (d.getDigit(0) < 5) {
                return ZERO_BY_LONG;
            }
            d = BCDDecimal.parseBCD("1.000000000000000").shift(-digit);
        } else if (Decimal64.isNormalized(l)) {
            d = Decimal64.getFractionField(l);
            if (-digit < e - 15) {
                return l;
            }
            d = d.round(digit + e).shift(e);
        } else {
            d = Decimal64.getFractionField(l);
            if (-digit < MIN_EXPONENT) {
                return l;
            }
            d = d.round(digit + MIN_NORMALIZED_EXPONENT).shift(e + 1);
        }
        return Decimal64.toDecimal(Decimal64.getSignum(l) > 0 ? d : d.negate());
    }

    public static long ceil(long l, int digit) {
        BCDDecimal d;
        int e = Decimal64.getExponent(l);
        if (Decimal64.isNaN(l) || Decimal64.isInfinite(l) || Decimal64.isZero(l)) {
            return l;
        }
        if (-digit >= e + 1) {
            BCDDecimal d2 = Decimal64.getFractionField(l);
            if (Decimal64.getSignum(l) > 0) {
                d2 = BCDDecimal.parseBCD("1.000000000000000").shift(-digit);
                return Decimal64.toDecimal(d2);
            }
            return ZERO_BY_LONG;
        }
        if (Decimal64.isNormalized(l)) {
            d = Decimal64.getFractionField(l);
            BCDDecimal bCDDecimal = d = Decimal64.getSignum(l) > 0 ? d : d.negate();
            if (-digit < e - 15) {
                return l;
            }
            d = d.ceil(digit + e).shift(e);
        } else {
            d = Decimal64.getFractionField(l);
            BCDDecimal bCDDecimal = d = Decimal64.getSignum(l) > 0 ? d : d.negate();
            if (-digit < MIN_EXPONENT) {
                return l;
            }
            d = d.ceil(digit + MIN_NORMALIZED_EXPONENT).shift(e + 1);
        }
        return Decimal64.toDecimal(d);
    }

    public static long floor(long l, int digit) {
        BCDDecimal d;
        int e = Decimal64.getExponent(l);
        if (Decimal64.isNaN(l) || Decimal64.isInfinite(l) || Decimal64.isZero(l)) {
            return l;
        }
        if (-digit >= e + 1) {
            BCDDecimal d2 = Decimal64.getFractionField(l);
            if (Decimal64.getSignum(l) > 0) {
                return ZERO_BY_LONG;
            }
            d2 = BCDDecimal.parseBCD("-1.000000000000000").shift(-digit);
            return Decimal64.toDecimal(d2);
        }
        if (Decimal64.isNormalized(l)) {
            d = Decimal64.getFractionField(l);
            BCDDecimal bCDDecimal = d = Decimal64.getSignum(l) > 0 ? d : d.negate();
            if (-digit < e - 15) {
                return l;
            }
            d = d.floor(digit + e).shift(e);
        } else {
            d = Decimal64.getFractionField(l);
            BCDDecimal bCDDecimal = d = Decimal64.getSignum(l) > 0 ? d : d.negate();
            if (-digit < MIN_EXPONENT) {
                return l;
            }
            d = d.floor(digit + MIN_NORMALIZED_EXPONENT).shift(e + 1);
        }
        return Decimal64.toDecimal(d);
    }

    public static String toString(long value) {
        if (Decimal64.isNaN(value)) {
            return "NaN";
        }
        if (Decimal64.isInfinite(value)) {
            return Decimal64.getSignum(value) > 0 ? "Infinity" : "-Infinity";
        }
        if (Decimal64.isZero(value)) {
            return Decimal64.getSignum(value) > 0 ? "0.0" : "-0.0";
        }
        BCDDecimal f = Decimal64.getFractionField(value);
        int e = Decimal64.getExponent(value);
        return f.shift(e).toString().replaceFirst("0+((e(\\+|-)?[0-9]+)?)$", "$1");
    }

    public static String toString(long value, int precision) {
        if (Decimal64.isNaN(value)) {
            return "NaN";
        }
        if (Decimal64.isInfinite(value)) {
            return Decimal64.getSignum(value) > 0 ? "Infinity" : "-Infinity";
        }
        if (Decimal64.isZero(value)) {
            return Decimal64.getSignum(value) > 0 ? "0.0" : "-0.0";
        }
        BCDDecimal f = Decimal64.getFractionField(value);
        int e = Decimal64.getExponent(value);
        return f.shift(e).toString(precision).replaceFirst("0+((e(\\+|-)?[0-9]+)?)$", "$1");
    }

    public static double doubleValue(long l) {
        if (Decimal64.isNaN(l)) {
            return Double.NaN;
        }
        if (Decimal64.isInfinite(l)) {
            return (double)Decimal64.getSignum(l) * Double.POSITIVE_INFINITY;
        }
        if (Decimal64.isZero(l)) {
            return (double)Decimal64.getSignum(l) * 0.0;
        }
        return Double.parseDouble(Decimal64.toString(l));
    }

    public static float floatValue(long l) {
        if (Decimal64.isNaN(l)) {
            return Float.NaN;
        }
        if (Decimal64.isInfinite(l)) {
            return (float)Decimal64.getSignum(l) * Float.POSITIVE_INFINITY;
        }
        if (Decimal64.isZero(l)) {
            return (float)Decimal64.getSignum(l) * 0.0f;
        }
        return Float.parseFloat(Decimal64.toString(l));
    }

    public static int compare(long a, long b) {
        if (Decimal64.isNaN(a)) {
            return Decimal64.isNaN(b) ? 0 : 1;
        }
        if (Decimal64.isNaN(b)) {
            return -1;
        }
        if (Decimal64.isInfinite(a)) {
            if (Decimal64.getSignum(a) > 0) {
                return Decimal64.isInfinite(b) && Decimal64.getSignum(b) > 0 ? 0 : 1;
            }
            return Decimal64.isInfinite(b) && Decimal64.getSignum(b) < 0 ? 0 : -1;
        }
        if (Decimal64.isInfinite(b)) {
            return Decimal64.getSignum(b) > 0 ? -1 : 1;
        }
        if (Decimal64.isNormalized(a)) {
            if (Decimal64.isNormalized(b)) {
                int eb;
                int ea = Decimal64.getExponent(a);
                if (ea > (eb = Decimal64.getExponent(b))) {
                    return 1;
                }
                if (ea < eb) {
                    return -1;
                }
                BCDDecimal da = Decimal64.getFractionField(a);
                BCDDecimal db = Decimal64.getFractionField(b);
                return da.compareTo(db);
            }
            return 1;
        }
        if (Decimal64.isNormalized(b)) {
            return -1;
        }
        BCDDecimal da = Decimal64.getFractionField(a);
        BCDDecimal db = Decimal64.getFractionField(b);
        return da.compareTo(db);
    }

    public static long decimal32To64(int l) {
        return Decimal64.toDecimal(Decimal32.toBCDDecimal(l));
    }

    public static long toDecimal(BigDecimal b) {
        BCDInteger bi = BCDInteger.valueOf(b.unscaledValue());
        BCDDecimal dd = new BCDDecimal(bi, 0);
        return Decimal64.toDecimal(dd.shift(-b.scale()));
    }

    @Override
    public int compareTo(Decimal64 o) {
        return Decimal64.compare(this.value, o.value);
    }

    @Override
    public int intValue() {
        return Decimal64.toBigDecimal(this.value).intValue();
    }

    @Override
    public long longValue() {
        return Decimal64.toBigDecimal(this.value).longValue();
    }

    @Override
    public float floatValue() {
        return Decimal64.floatValue(this.value);
    }

    @Override
    public double doubleValue() {
        return Decimal64.doubleValue(this.value);
    }
}

