/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lang;

import java.math.BigDecimal;
import net.morilib.lang.BCDInteger;

public class BCDDecimal
extends Number
implements Comparable<BCDDecimal> {
    public static final BCDDecimal ZERO = new BCDDecimal(BCDInteger.ZERO, 0);
    private int point;
    private BCDInteger value;

    public BCDDecimal(BCDInteger value, int point) {
        this.point = point;
        this.value = value;
    }

    public static BCDDecimal valueOf(long value, int point) {
        return new BCDDecimal(BCDInteger.valueOf(value), point);
    }

    public static BCDDecimal parseBCD(String s) {
        int pd;
        StringBuilder b = new StringBuilder();
        int pp = -1;
        int ed = 0;
        int esgn = 0;
        int pm = -1;
        boolean folf = true;
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (folf && c == '+') {
                folf = false;
            } else if (folf && c == '-') {
                if (esgn == 0) {
                    b.append('-');
                } else {
                    esgn = -1;
                }
                folf = false;
            } else if (c >= '0' && c <= '9') {
                if (esgn == 0) {
                    b.append(c);
                } else {
                    ed = ed * 10 + (c - 48);
                }
            } else if (pp < 0 && esgn == 0 && c == '.') {
                pp = i;
            } else if (esgn == 0 && (c == 'e' || c == 'E')) {
                esgn = 1;
                pm = i;
                folf = true;
            } else {
                throw new NumberFormatException();
            }
            ++i;
        }
        int n = pm = pm < 0 ? s.length() : pm;
        if (pp < 0) {
            pd = 0;
        } else {
            if (pp + 1 == s.length()) {
                throw new NumberFormatException();
            }
            pd = pm - (pp + 1);
        }
        BCDInteger bi = BCDInteger.parseBCD(b.toString());
        if (bi.isZero()) {
            return ZERO;
        }
        if (esgn == 0) {
            return new BCDDecimal(bi, pd);
        }
        return new BCDDecimal(bi, pd - esgn * ed);
    }

    public static BCDDecimal valueOf(double x) {
        if (Double.isNaN(x) || Double.isInfinite(x)) {
            throw new IllegalArgumentException();
        }
        return BCDDecimal.parseBCD(Double.toString(x));
    }

    public int getPoint() {
        return this.point;
    }

    public BCDDecimal add(BCDDecimal b) {
        BCDInteger va = this.value;
        BCDInteger vb = b.value;
        int vp = this.point;
        if (this.point < b.point) {
            va = va.shift(b.point - this.point);
            vp = b.point;
        } else if (this.point > b.point) {
            vb = vb.shift(this.point - b.point);
        }
        return new BCDDecimal(va.add(vb), vp);
    }

    public BCDDecimal subtract(BCDDecimal b) {
        BCDInteger va = this.value;
        BCDInteger vb = b.value;
        int vp = this.point;
        if (this.point < b.point) {
            va = va.shift(b.point - this.point);
            vp = b.point;
        } else if (this.point > b.point) {
            vb = vb.shift(this.point - b.point);
        }
        return new BCDDecimal(va.subtract(vb), vp);
    }

    public BCDDecimal multiply(BCDDecimal b) {
        return new BCDDecimal(this.value.multiply(b.value), this.point + b.point);
    }

    public BCDDecimal divide(BCDDecimal b) {
        return new BCDDecimal(this.value.divide(b.value), this.point - b.point);
    }

    public BCDDecimal negate() {
        return new BCDDecimal(this.value.negate(), this.point);
    }

    public BCDDecimal round(int digit) {
        int d = this.value.getDigit(this.point - digit - 1);
        BCDInteger vr = this.value.shift(digit - this.point);
        return new BCDDecimal(d < 5 ? vr : vr.succ(), digit);
    }

    public BCDDecimal ceil(int digit) {
        BCDInteger vr = this.value.shift(digit - this.point);
        if (this.value.signum() > 0) {
            return new BCDDecimal(vr.succ(), digit);
        }
        return new BCDDecimal(vr, digit);
    }

    public BCDDecimal floor(int digit) {
        BCDInteger vr = this.value.shift(digit - this.point);
        if (this.value.signum() > 0) {
            return new BCDDecimal(vr, digit);
        }
        return new BCDDecimal(vr.prev(), digit);
    }

    @Override
    public int intValue() {
        return (int)this.longValue();
    }

    @Override
    public long longValue() {
        if (this.point > 0) {
            return this.round((int)0).value.longValue();
        }
        return this.value.shift(-this.point).longValue();
    }

    @Override
    public float floatValue() {
        return (float)this.doubleValue();
    }

    @Override
    public double doubleValue() {
        return Double.parseDouble(this.toString());
    }

    public int getMostSignificantDigit() {
        return this.value.digits() - this.point - 1;
    }

    public boolean isZero() {
        return this.value.isZero();
    }

    public int getDigit(int digit) {
        return this.value.getDigit(digit + this.point);
    }

    public int signum() {
        return this.value.signum();
    }

    public BCDDecimal shift(int digit) {
        return new BCDDecimal(this.value, this.point - digit);
    }

    public BCDDecimal shiftExtend(int digit) {
        return new BCDDecimal(this.value.shift(digit), this.point + digit);
    }

    public int precision() {
        return this.value.digits();
    }

    @Override
    public int compareTo(BCDDecimal b) {
        BCDInteger va = this.value;
        BCDInteger vb = b.value;
        if (this.point < b.point) {
            va = va.shift(b.point - this.point);
        } else if (this.point > b.point) {
            vb = vb.shift(this.point - b.point);
        }
        return va.compareTo(vb);
    }

    public BigDecimal toBigDecimal() {
        return new BigDecimal(this.value.toBigInteger(), this.point);
    }

    public int hashCode() {
        int r = 17;
        if (this.isZero()) {
            return 0;
        }
        r = 37 * (r + this.value.intValue());
        r = 37 * (r + this.point);
        return r;
    }

    public boolean equals(Object o) {
        if (o instanceof BCDDecimal) {
            return this.compareTo((BCDDecimal)o) == 0;
        }
        return false;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        int l0 = this.value.digits() - this.point;
        if (this.point < 0 || this.point > 10) {
            if (this.value.signum() < 0) {
                b.append("-");
            }
            b.append((char)(this.value.getDigit(this.value.digits() - 1) + 48));
            b.append(".");
            int i = this.value.digits() - 2;
            while (i >= 0) {
                b.append((char)(this.value.getDigit(i) + 48));
                --i;
            }
            b.append("e").append(l0 - 1);
        } else if (this.point == 0) {
            b.append(this.value.toString());
        } else if (l0 <= 0) {
            if (this.value.signum() < 0) {
                b.append("-");
            }
            b.append("0.");
            int i = 0;
            while (i < -l0) {
                b.append("0");
                ++i;
            }
            b.append(this.value.abs().toString());
        } else {
            if (this.value.signum() < 0) {
                b.append("-");
            }
            int i = this.value.digits();
            while (i > this.point) {
                b.append((char)(this.value.getDigit(i - 1) + 48));
                --i;
            }
            b.append(".");
            i = this.point;
            while (i > 0) {
                b.append((char)(this.value.getDigit(i - 1) + 48));
                --i;
            }
        }
        return b.toString();
    }

    public String toString(int precision) {
        return this.shiftExtend(precision - this.precision()).toString();
    }
}

