/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.geometry.g2d;

import net.morilib.geometry.g2d.Vector2D;
import net.morilib.geometry.g2d.VectorTransformer2D;
import net.morilib.lang.algebra.FieldElement;
import net.morilib.lang.number.NumericalField;
import net.morilib.lang.number.NumericalFieldElement;

public class AffineTransformer2D<P extends Vector2D<P, F>, F extends FieldElement<F>>
implements VectorTransformer2D<P, F> {
    private F scaleX;
    private F scaleY;
    private F shearX;
    private F shearY;
    private F transformX;
    private F transformY;

    public AffineTransformer2D(F scaleX, F scaleY, F shearX, F shearY, F transformX, F transformY) {
        this.scaleX = scaleX;
        this.shearX = shearX;
        this.transformX = transformX;
        this.scaleY = scaleY;
        this.shearY = shearY;
        this.transformY = transformY;
    }

    public static <P extends Vector2D<P, F>, F extends NumericalFieldElement<F>> AffineTransformer2D<P, F> getRotator(NumericalField<F> ff, double theta) {
        double sin = Math.sin(theta);
        double cos = Math.cos(theta);
        return new AffineTransformer2D<P, NumericalFieldElement>((NumericalFieldElement)ff.valueOf(cos), (NumericalFieldElement)ff.valueOf(cos), (NumericalFieldElement)ff.valueOf(-sin), (NumericalFieldElement)ff.valueOf(sin), (NumericalFieldElement)ff.getZero(), (NumericalFieldElement)ff.getZero());
    }

    public static <P extends Vector2D<P, F>, F extends NumericalFieldElement<F>> AffineTransformer2D<P, F> getRotator(NumericalField<F> ff, P anchor, double theta) {
        double x = ((NumericalFieldElement)anchor.getX()).doubleValue();
        double y = ((NumericalFieldElement)anchor.getY()).doubleValue();
        double sin = Math.sin(theta);
        double cos = Math.cos(theta);
        return new AffineTransformer2D<P, F>(ff.valueOf(cos), ff.valueOf(cos), ff.valueOf(-sin), ff.valueOf(sin), ff.valueOf(x - x * cos + y * sin), ff.valueOf(y - x * sin - y * cos));
    }

    public F getScaleX() {
        return this.scaleX;
    }

    public F getScaleY() {
        return this.scaleY;
    }

    public F getShearX() {
        return this.shearX;
    }

    public F getShearY() {
        return this.shearY;
    }

    public F getTransformX() {
        return this.transformX;
    }

    public F getTransformY() {
        return this.transformY;
    }

    @Override
    public P transform(P p) {
        FieldElement x = (FieldElement)this.scaleX.multiply(p.getX());
        x = (FieldElement)((FieldElement)x.add(this.shearX)).multiply(p.getY());
        x = (FieldElement)x.add(this.transformX);
        FieldElement y = (FieldElement)this.scaleY.multiply(p.getY());
        y = (FieldElement)((FieldElement)y.add(this.shearY)).multiply(p.getX());
        y = (FieldElement)y.add(this.transformY);
        return p.getFactory().create(x, y);
    }
}

