/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.geography;

import net.morilib.arith.NonnegativeDegree;

public class Longitude
extends Number {
    private int PERIOD = 129600000;
    private int MAXSEC = 1296000;
    private int HALFPERIOD = 64800000;
    private int HALFSEC = 648000;
    private static NonnegativeDegree PERIOD_DEG = new NonnegativeDegree(360, 0, 0, 0);
    private static NonnegativeDegree PRIME_MERIDIAN = new NonnegativeDegree(180, 0, 0, 0);
    private static NonnegativeDegree MAX_D = new NonnegativeDegree(180, 0, 0, 0);
    private NonnegativeDegree degree;

    Longitude(int x) {
        this.degree = new NonnegativeDegree(x);
    }

    Longitude(NonnegativeDegree degree) {
        this.degree = degree;
    }

    public Longitude(int degree, int minutes, int seconds, int undersec) {
        if (degree < -180 || degree > 180) {
            throw new IllegalArgumentException();
        }
        this.degree = degree > 0 ? new NonnegativeDegree(degree + 180, minutes, seconds, undersec) : (degree < 0 ? PRIME_MERIDIAN.subtract(new NonnegativeDegree(-degree, minutes, seconds, undersec)) : (minutes > 0 ? new NonnegativeDegree(180, minutes, seconds, undersec) : (minutes < 0 ? PRIME_MERIDIAN.subtract(new NonnegativeDegree(0, -minutes, seconds, undersec)) : (seconds > 0 ? new NonnegativeDegree(180, 0, seconds, undersec) : (seconds < 0 ? PRIME_MERIDIAN.subtract(new NonnegativeDegree(0, 0, -seconds, undersec)) : (undersec > 0 ? new NonnegativeDegree(180, 0, 0, undersec) : (undersec < 0 ? PRIME_MERIDIAN.subtract(new NonnegativeDegree(0, 0, 0, -undersec)) : PRIME_MERIDIAN)))))));
    }

    public static Longitude parse(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        if (string.length() == 0) {
            throw new NumberFormatException();
        }
        switch (string.charAt(string.length() - 1)) {
            case 'E': {
                NonnegativeDegree d = NonnegativeDegree.parse(string.substring(0, string.length() - 1));
                if (d.compareTo(MAX_D) > 0) {
                    throw new NumberFormatException();
                }
                return new Longitude(d.add(PRIME_MERIDIAN));
            }
            case 'W': {
                NonnegativeDegree d = NonnegativeDegree.parse(string.substring(0, string.length() - 1));
                if (d.compareTo(MAX_D) > 0) {
                    throw new NumberFormatException();
                }
                return new Longitude(PRIME_MERIDIAN.subtract(d));
            }
        }
        throw new NumberFormatException();
    }

    public Longitude add(Longitude x) {
        return new Longitude(this.degree.add(x.degree).add(MAX_D).remainder(PERIOD_DEG));
    }

    public Longitude subtract(Longitude x) {
        if (this.degree.compareTo(x.degree) >= 0) {
            return new Longitude(this.degree.subtract(x.degree).add(MAX_D));
        }
        return new Longitude(PERIOD_DEG.subtract(x.degree.subtract(this.degree)).add(MAX_D));
    }

    public Longitude multiply(int x) {
        long a = this.degree.toCentiSecond() - this.HALFPERIOD;
        a = (a * (long)x + (long)this.HALFPERIOD) % (long)this.PERIOD;
        return new Longitude(new NonnegativeDegree((int)a));
    }

    public Longitude multiply(double x) {
        double r = (this.degree.doubleValue() - (double)this.HALFSEC) * x + (double)this.HALFSEC;
        r = (r = Math.IEEEremainder(r, this.MAXSEC)) < 0.0 ? (double)this.MAXSEC + r : r;
        return new Longitude(new NonnegativeDegree(r));
    }

    public Longitude divide(int x) {
        long a = ((this.degree.toCentiSecond() - this.HALFPERIOD) / Math.abs(x) + this.HALFPERIOD) % this.PERIOD;
        a = x < 0 ? (long)this.PERIOD - a : a;
        return new Longitude(new NonnegativeDegree((int)a));
    }

    public Longitude divide(double x) {
        double r = (this.degree.doubleValue() - (double)this.HALFSEC) / x + (double)this.HALFSEC;
        r = (r = Math.IEEEremainder(r, this.MAXSEC)) < 0.0 ? (double)this.MAXSEC + r : r;
        return new Longitude(new NonnegativeDegree(r));
    }

    @Override
    public int intValue() {
        return this.degree.intValue();
    }

    @Override
    public long longValue() {
        return this.degree.longValue();
    }

    @Override
    public float floatValue() {
        return this.degree.floatValue();
    }

    @Override
    public double doubleValue() {
        return this.degree.doubleValue();
    }

    public int hashCode() {
        return this.degree.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof Longitude) {
            return this.degree.equals(((Longitude)o).degree);
        }
        return false;
    }

    public String toString() {
        if (this.degree.compareTo(PRIME_MERIDIAN) > 0) {
            return String.valueOf(this.degree.subtract(PRIME_MERIDIAN).toString()) + "E";
        }
        if (this.degree.compareTo(PRIME_MERIDIAN) < 0) {
            return String.valueOf(PRIME_MERIDIAN.subtract(this.degree).toString()) + "W";
        }
        return NonnegativeDegree.ZERO.toString();
    }
}

