/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.calendar;

import net.morilib.calendar.AbstractDay;
import net.morilib.calendar.SimpleGregorianCalendar;
import net.morilib.calendar.WeekSolarCalendar;

public class SimpleJulianCalendar
extends AbstractDay
implements WeekSolarCalendar {
    private static final int DAYS_4YEARS = 1461;
    private static final int AD_1 = 44;
    private static final int DAYS_TO_UNIX_EPOCH = 735601;
    private static final long DAY_MILLISECS = 86400000L;
    private static final int[] DAYS_YEARS;
    private static final int[] LMAX_DAYS_OF_MONTH;
    private static final int[] LMAX_DAYS_OF_MONTH_L;
    private static final int[] ACC_LMAX_DAYS_OF_MONTH;
    private static final int[] ACC_LMAX_DAYS_OF_MONTH_L;
    private int days;

    static {
        int[] nArray = new int[4];
        nArray[1] = 366;
        nArray[2] = 731;
        nArray[3] = 1096;
        DAYS_YEARS = nArray;
        LMAX_DAYS_OF_MONTH = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        LMAX_DAYS_OF_MONTH_L = new int[]{31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        ACC_LMAX_DAYS_OF_MONTH = new int[]{31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334, 365};
        ACC_LMAX_DAYS_OF_MONTH_L = new int[]{31, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335, 366};
    }

    public SimpleJulianCalendar(int year, int month, int day) {
        int[] a;
        if (year == 0) {
            throw new IllegalArgumentException();
        }
        int y = year < 0 ? 44 + year + 1 : year + 44;
        int my = y % 4;
        my = my < 0 ? my + 4 : my;
        int ay = y < 0 ? (y - 3) / 4 : y / 4;
        int[] p = my > 0 ? LMAX_DAYS_OF_MONTH : LMAX_DAYS_OF_MONTH_L;
        int[] nArray = a = my > 0 ? ACC_LMAX_DAYS_OF_MONTH : ACC_LMAX_DAYS_OF_MONTH_L;
        if (month < 1 || month > 12) {
            throw new IllegalArgumentException();
        }
        if (day < 1 || day > p[month - 1]) {
            throw new IllegalArgumentException();
        }
        this.days = ay * 1461 + DAYS_YEARS[my];
        this.days += month < 2 ? 0 : a[month - 2];
        this.days += day - 1;
    }

    public SimpleJulianCalendar(int days) {
        this.days = days;
    }

    public static SimpleJulianCalendar getInstaceFromTime(long time) {
        int t = (int)SimpleGregorianCalendar.div(time, 86400000L);
        return new SimpleJulianCalendar(t + 735601);
    }

    @Override
    public int getDaysFromEpoch() {
        return this.days;
    }

    @Override
    public long getDate() {
        return (long)(this.days - 735601) * 86400000L;
    }

    private static int toyear(int y) {
        return y > 44 ? y - 44 : y - 44 - 1;
    }

    @Override
    public int getYear() {
        int x = this.days / 1461;
        x = this.days < 0 ? (this.days - 1461 - 1) / 1461 : this.days / 1461;
        int y = this.days % 1461;
        int n = y = y < 0 ? y + 1461 : y;
        if (y < 366) {
            return SimpleJulianCalendar.toyear(x * 4);
        }
        if (y < 731) {
            return SimpleJulianCalendar.toyear(x * 4 + 1);
        }
        if (y < 1096) {
            return SimpleJulianCalendar.toyear(x * 4 + 2);
        }
        return SimpleJulianCalendar.toyear(x * 4 + 3);
    }

    @Override
    public int getDayOfYear() {
        int y = this.days % 1461;
        int n = y = y < 0 ? y + 1461 : y;
        if (y < 366) {
            return y + 1;
        }
        if (y < 731) {
            return y - 366 + 1;
        }
        if (y < 1096) {
            return y - 366 - 365 + 1;
        }
        return y - 366 - 730 + 1;
    }

    @Override
    public int getMaximumDaysOfYear() {
        int d = this.days % 1461;
        d = d < 0 ? d + 1461 : d;
        return d < 366 ? 366 : 365;
    }

    @Override
    public boolean isLeapYear() {
        return this.getMaximumDaysOfYear() == 366;
    }

    @Override
    public int getDayOfMonth() {
        int[] l = this.isLeapYear() ? LMAX_DAYS_OF_MONTH_L : LMAX_DAYS_OF_MONTH;
        int d = this.getDayOfYear() - 1;
        int i = 0;
        while (i < l.length) {
            if (d < l[i]) {
                return d + 1;
            }
            d -= l[i];
            ++i;
        }
        throw new RuntimeException();
    }

    @Override
    public int getMaximumDaysOfMonth() {
        int[] l = this.isLeapYear() ? ACC_LMAX_DAYS_OF_MONTH_L : ACC_LMAX_DAYS_OF_MONTH;
        int[] r = this.isLeapYear() ? LMAX_DAYS_OF_MONTH_L : LMAX_DAYS_OF_MONTH;
        int d = this.getDayOfYear() - 1;
        int i = 0;
        while (i < l.length) {
            if (d < l[i]) {
                return r[i];
            }
            ++i;
        }
        throw new RuntimeException();
    }

    @Override
    public int getMonth() {
        int[] l = this.isLeapYear() ? LMAX_DAYS_OF_MONTH_L : LMAX_DAYS_OF_MONTH;
        int d = this.getDayOfYear() - 1;
        int i = 0;
        while (i < l.length) {
            if (d < l[i]) {
                return i + 1;
            }
            d -= l[i];
            ++i;
        }
        throw new RuntimeException();
    }

    @Override
    public int getDayOfWeek() {
        int r = (this.days + 5) % 7;
        return r < 0 ? r + 7 : r;
    }

    @Override
    public SimpleJulianCalendar after(int days) {
        return new SimpleJulianCalendar(this.days + days);
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        int y = this.getYear();
        if (y < 0) {
            y = -y;
            b.append("BC");
        }
        b.append(y).append("/").append(this.getMonth());
        b.append("/").append(this.getDayOfMonth());
        b.append(" (Julian)");
        return b.toString();
    }
}

