/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.calendar;

import net.morilib.calendar.AbstractDay;
import net.morilib.calendar.WeekSolarCalendar;

public class SimpleGregorianCalendar
extends AbstractDay
implements WeekSolarCalendar {
    private static final int DAYS_400YEARS = 146097;
    private static final int DAYS_100YEARS = 36524;
    private static final int DAYS_4YEARS = 1461;
    private static final int DAYS_TO_UNIX_EPOCH = 719162;
    private static final long DAY_MILLISECS = 86400000L;
    private static final int[] LMAX_DAYS_OF_MONTH = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final int[] LMAX_DAYS_OF_MONTH_L = new int[]{31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final int[] ACC_LMAX_DAYS_OF_MONTH = new int[]{31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334, 365};
    private static final int[] ACC_LMAX_DAYS_OF_MONTH_L = new int[]{31, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335, 366};
    private int days;

    public SimpleGregorianCalendar(int year, int month, int day) {
        int[] a;
        if (year == 0) {
            throw new IllegalArgumentException();
        }
        int y = year < 0 ? year : year - 1;
        int my = SimpleGregorianCalendar.div(y, 400);
        int ny = SimpleGregorianCalendar.mod(y, 400);
        int oy = SimpleGregorianCalendar.div(ny, 100);
        int py = SimpleGregorianCalendar.mod(ny, 100);
        int qy = SimpleGregorianCalendar.div(py, 4);
        int ry = SimpleGregorianCalendar.mod(py, 4);
        int[] p = SimpleGregorianCalendar.isLeapNormalizedYear(y + 1) ? LMAX_DAYS_OF_MONTH_L : LMAX_DAYS_OF_MONTH;
        int[] nArray = a = SimpleGregorianCalendar.isLeapNormalizedYear(y + 1) ? ACC_LMAX_DAYS_OF_MONTH_L : ACC_LMAX_DAYS_OF_MONTH;
        if (month < 1 || month > 12) {
            throw new IllegalArgumentException();
        }
        if (day < 1 || day > p[month - 1]) {
            throw new IllegalArgumentException();
        }
        this.days = my * 146097;
        this.days += oy * 36524;
        this.days += qy * 1461;
        this.days += ry * 365;
        this.days += month < 2 ? 0 : a[month - 2];
        this.days += day - 1;
    }

    public SimpleGregorianCalendar(int days) {
        this.days = days;
    }

    public static SimpleGregorianCalendar getInstaceFromTime(long time) {
        int t = (int)SimpleGregorianCalendar.div(time, 86400000L);
        return new SimpleGregorianCalendar(t + 719162);
    }

    @Override
    public int getDaysFromEpoch() {
        return this.days;
    }

    @Override
    public long getDate() {
        return (long)(this.days - 719162) * 86400000L;
    }

    static int div(int x, int y) {
        return x < 0 ? (x - y + 1) / y : x / y;
    }

    static long div(long x, long y) {
        return x < 0L ? (x - y + 1L) / y : x / y;
    }

    static int mod(int x, int y) {
        int r = x % y;
        return r < 0 ? r + y : r;
    }

    private static int getYear100(int d) {
        int x = SimpleGregorianCalendar.div(d, 1461);
        int y = SimpleGregorianCalendar.mod(d, 1461);
        if (y < 365) {
            return x * 4 + 0;
        }
        if (y < 730) {
            return x * 4 + 1;
        }
        if (y < 1095) {
            return x * 4 + 2;
        }
        return x * 4 + 3;
    }

    private int getNormalizedYear() {
        int x = SimpleGregorianCalendar.div(this.days, 146097);
        int y = SimpleGregorianCalendar.mod(this.days, 146097);
        int z = SimpleGregorianCalendar.div(y, 36524);
        int w = SimpleGregorianCalendar.mod(y, 36524);
        if (z < 4) {
            return x * 400 + z * 100 + SimpleGregorianCalendar.getYear100(w) + 1;
        }
        return x * 400 + 400;
    }

    @Override
    public int getYear() {
        int r = this.getNormalizedYear();
        return r > 0 ? r : r - 1;
    }

    private static int getDayOfYear100(int d) {
        int y = SimpleGregorianCalendar.mod(d, 1461);
        return (y < 1095 ? SimpleGregorianCalendar.mod(y, 365) : y - 1095) + 1;
    }

    @Override
    public int getDayOfYear() {
        int y = SimpleGregorianCalendar.mod(this.days, 146097);
        int z = SimpleGregorianCalendar.div(y, 36524);
        int w = SimpleGregorianCalendar.mod(y, 36524);
        return z < 4 ? SimpleGregorianCalendar.getDayOfYear100(w) : 365;
    }

    @Override
    public int getMaximumDaysOfYear() {
        return this.isLeapYear() ? 366 : 365;
    }

    private static boolean isLeapNormalizedYear(int y) {
        return y % 400 == 0 || y % 4 == 0 && y % 100 != 0;
    }

    @Override
    public boolean isLeapYear() {
        return SimpleGregorianCalendar.isLeapNormalizedYear(this.getNormalizedYear());
    }

    @Override
    public int getDayOfMonth() {
        int[] l = this.isLeapYear() ? LMAX_DAYS_OF_MONTH_L : LMAX_DAYS_OF_MONTH;
        int d = this.getDayOfYear() - 1;
        int i = 0;
        while (i < l.length) {
            if (d < l[i]) {
                return d + 1;
            }
            d -= l[i];
            ++i;
        }
        throw new RuntimeException();
    }

    @Override
    public int getMaximumDaysOfMonth() {
        int[] l = this.isLeapYear() ? ACC_LMAX_DAYS_OF_MONTH_L : ACC_LMAX_DAYS_OF_MONTH;
        int[] r = this.isLeapYear() ? LMAX_DAYS_OF_MONTH_L : LMAX_DAYS_OF_MONTH;
        int d = this.getDayOfYear() - 1;
        int i = 0;
        while (i < l.length) {
            if (d < l[i]) {
                return r[i];
            }
            ++i;
        }
        throw new RuntimeException();
    }

    @Override
    public int getMonth() {
        int[] l = this.isLeapYear() ? LMAX_DAYS_OF_MONTH_L : LMAX_DAYS_OF_MONTH;
        int d = this.getDayOfYear() - 1;
        int i = 0;
        while (i < l.length) {
            if (d < l[i]) {
                return i + 1;
            }
            d -= l[i];
            ++i;
        }
        throw new RuntimeException();
    }

    @Override
    public int getDayOfWeek() {
        int r = (this.days + 1) % 7;
        return r < 0 ? r + 7 : r;
    }

    @Override
    public SimpleGregorianCalendar after(int days) {
        return new SimpleGregorianCalendar(this.days + days);
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        int y = this.getYear();
        if (y < 0) {
            y = -y;
            b.append("BC");
        }
        b.append(y).append("/").append(this.getMonth());
        b.append("/").append(this.getDayOfMonth());
        b.append(" (Gregorian)");
        return b.toString();
    }
}

