/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.automata.trie;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.morilib.automata.DFAState;
import net.morilib.automata.trie.Trie;
import net.morilib.automata.trie.TrieNode;
import net.morilib.automata.trie.TrieValueMatcher;

public class IntegerTrieValueMatcher<A> {
    private Trie<Integer, A> trie;
    private TrieNode<Integer, A> node;
    private Map<TrieNode<Integer, A>, Map<Integer, TrieNode<Integer, A>>> fail;
    private CharSequence str;
    private int ptr = 0;

    public IntegerTrieValueMatcher(Trie<Integer, A> trie, CharSequence str) {
        this.trie = trie;
        this.str = str;
        this.node = trie.getInitialState();
        this.initfail(trie);
    }

    private void initfail(Trie<Integer, A> trie) {
        TrieNode<Integer, A> init = trie.getInitialState();
        ArrayList<Integer> lst = new ArrayList<Integer>();
        this.fail = new HashMap<TrieNode<Integer, A>, Map<Integer, TrieNode<Integer, A>>>();
        for (Integer t : init.getEdges().keySet()) {
            lst.add(t);
            TrieValueMatcher.gennode(trie, this.fail, init.go((Object)t), lst);
            lst.remove(lst.size() - 1);
        }
    }

    public A nextValue() {
        A acc = null;
        while (this.ptr < this.str.length()) {
            char c;
            DFAState n;
            if (((TrieNode)(n = this.node.goInt(c = this.str.charAt(this.ptr++)))).isDead()) {
                TrieNode<Integer, A> m;
                Map<Integer, TrieNode<Integer, A>> x = this.fail.get(this.node);
                this.node = this.node.isAccepted() || x == null ? this.trie.getInitialState() : ((m = x.get(c)) == null ? this.trie.getInitialState() : m);
                if (!((TrieNode)this.node.goInt(c)).isDead()) {
                    --this.ptr;
                }
                if (acc == null) continue;
                return acc;
            }
            if (((TrieNode)n).isAccepted()) {
                acc = ((TrieNode)n).getAccepted().iterator().next();
                this.node = n;
                continue;
            }
            this.node = n;
        }
        return acc;
    }
}

