/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.automata.trie;

import java.util.ArrayList;
import java.util.Iterator;
import net.morilib.automata.trie.Trie;
import net.morilib.automata.trie.TrieTransducer;

public class IntegerTrieTransducer
extends TrieTransducer<Integer> {
    private String result = null;

    public IntegerTrieTransducer(Trie<Integer, Integer> trie, Iterator<Integer> iter) {
        super(trie, iter);
    }

    public IntegerTrieTransducer(Trie<Integer, Integer> trie, String s) {
        super(trie, IntegerTrieTransducer.toiter(s).iterator());
    }

    private static Iterable<Integer> toiter(String s) {
        ArrayList<Integer> l = new ArrayList<Integer>();
        int i = 0;
        while (i < s.length()) {
            int x = s.codePointAt(i);
            l.add(x);
            i += x > 65535 ? 2 : 1;
        }
        return l;
    }

    public static String transduce(Trie<Integer, Integer> trie, String s) {
        return new IntegerTrieTransducer(trie, s).toString();
    }

    public String toString() {
        if (this.result != null) {
            return this.result;
        }
        StringBuffer r = new StringBuffer();
        while (this.hasNext()) {
            r.appendCodePoint((Integer)this.next());
        }
        this.result = r.toString();
        return this.result;
    }
}

