/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.automata.trie;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.morilib.automata.DFAState;
import net.morilib.automata.trie.Trie;
import net.morilib.automata.trie.TrieNode;
import net.morilib.automata.trie.TrieValueMatcher;

public class IntegerTrieMatcher<A> {
    private Trie<Integer, A> trie;
    private TrieNode<Integer, A> node;
    private Map<TrieNode<Integer, A>, Map<Integer, Integer>> back;
    private Map<TrieNode<Integer, A>, Map<Integer, TrieNode<Integer, A>>> fail;
    private StringBuilder buf = new StringBuilder();
    private CharSequence str;
    private int ptr = 0;

    public IntegerTrieMatcher(Trie<Integer, A> trie, CharSequence str) {
        this.trie = trie;
        this.str = str;
        this.node = trie.getInitialState();
        this.initfail(trie);
    }

    private void initfail(Trie<Integer, A> trie) {
        TrieNode<Integer, A> init = trie.getInitialState();
        ArrayList<Integer> lst = new ArrayList<Integer>();
        this.fail = new HashMap<TrieNode<Integer, A>, Map<Integer, TrieNode<Integer, A>>>();
        this.back = new HashMap<TrieNode<Integer, A>, Map<Integer, Integer>>();
        for (Integer t : init.getEdges().keySet()) {
            lst.add(t);
            TrieValueMatcher.gennode(trie, this.fail, this.back, init.go((Object)t), lst);
            lst.remove(lst.size() - 1);
        }
    }

    public String nextToken() {
        String acc = null;
        while (this.ptr < this.str.length()) {
            char c = this.str.charAt(this.ptr++);
            this.buf.append(c);
            DFAState n = this.node.goInt(c);
            if (((TrieNode)n).isDead()) {
                Map<Integer, TrieNode<Integer, A>> x = this.fail.get(this.node);
                if (this.node.isAccepted() || x == null) {
                    this.node = this.trie.getInitialState();
                    this.buf = new StringBuilder();
                } else {
                    TrieNode<Integer, A> m = x.get(c);
                    if (m == null) {
                        this.node = this.trie.getInitialState();
                        this.buf = new StringBuilder();
                    } else {
                        int b = this.back.get(this.node).get(c);
                        this.node = m;
                        this.buf.delete(this.buf.length() - b - 1, this.buf.length());
                        this.buf.append(c);
                    }
                }
                if (!((TrieNode)this.node.goInt(c)).isDead()) {
                    --this.ptr;
                }
                if (acc == null) continue;
                return acc;
            }
            if (((TrieNode)n).isAccepted()) {
                acc = this.buf.toString();
                this.node = n;
                continue;
            }
            this.node = n;
        }
        return acc;
    }
}

