/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.automata.trie;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.morilib.automata.DFAState;
import net.morilib.automata.FileFormatException;
import net.morilib.automata.Homomorphism;
import net.morilib.automata.TextBound;
import net.morilib.automata.dfa.DFAs;
import net.morilib.automata.trie.IntegerTrieBuilder;
import net.morilib.automata.trie.Trie;
import net.morilib.automata.trie.TrieNode;
import net.morilib.range.Interval;

public class IntegerTrie<A>
implements Trie<Integer, A>,
Homomorphism<A, Integer> {
    static final Node<Object> DEADNODE = new Node<Object>(-1, null, false);
    private Node<A> init;
    Map<A, String> map;

    IntegerTrie() {
        this.init = new Node<Object>(0, null, false);
        this.map = new HashMap<A, String>();
    }

    public IntegerTrie(IntegerTrie<A> trie) {
        this.init = IntegerTrie.copytrie(trie.init);
        this.map = new HashMap<A, String>();
    }

    private static <A> Node<A> copytrie(Node<A> n) {
        HashMap e = new HashMap();
        for (int i : n.edges.keySet()) {
            e.put(i, IntegerTrie.copytrie(n.edges.get(i)));
        }
        return new Node(((Node)n).nodeNo, n.value, e, n.isAccepted());
    }

    public static IntegerTrie<Integer> loadCharToString(InputStream ins) throws IOException {
        Properties p = new Properties();
        IntegerTrieBuilder<Integer> b = new IntegerTrieBuilder<Integer>();
        p.load(ins);
        for (Map.Entry<Object, Object> e : p.entrySet()) {
            String s = e.getKey().toString();
            String t = e.getValue().toString();
            if (s.codePointCount(0, s.length()) != 1) {
                throw new FileFormatException();
            }
            b.append(t, s.codePointAt(0));
        }
        return b.get();
    }

    public static IntegerTrie<String> loadStringToString(InputStream ins) throws IOException {
        Properties p = new Properties();
        IntegerTrieBuilder<String> b = new IntegerTrieBuilder<String>();
        p.load(ins);
        for (Map.Entry<Object, Object> e : p.entrySet()) {
            String s = e.getKey().toString();
            String t = e.getValue().toString();
            b.append(t, s);
        }
        return b.get();
    }

    public static IntegerTrie<Integer> loadCharToString(File file) throws IOException {
        FileInputStream ins = null;
        try {
            ins = new FileInputStream(file);
            IntegerTrie<Integer> integerTrie = IntegerTrie.loadCharToString(ins);
            return integerTrie;
        }
        finally {
            if (ins != null) {
                ((InputStream)ins).close();
            }
        }
    }

    public static IntegerTrie<Integer> loadCharToString(String filename) throws IOException {
        return IntegerTrie.loadCharToString(new File(filename));
    }

    public Node<A> getInitialState() {
        return this.init;
    }

    @Override
    public List<Integer> get(A a) {
        ArrayList<Integer> l = new ArrayList<Integer>();
        String s = this.getString(a);
        int i = 0;
        while (i < s.length()) {
            int c = s.codePointAt(i);
            l.add(c);
            i += c > 65535 ? 2 : 1;
        }
        return l;
    }

    public String getString(A a) {
        return this.map.get(a);
    }

    @Override
    public A invert(List<Integer> ts) {
        Node<A> s = this.init;
        for (Integer t : ts) {
            if (!(s = s.go(t)).isDead()) continue;
            return null;
        }
        return s.isAccepted() ? (A)s.value : null;
    }

    public A invert(Integer ... ts) {
        return this.invert(Arrays.asList(ts));
    }

    public A invert(String ts) {
        Node<A> s = this.init;
        int i = 0;
        while (i < ts.length()) {
            int c = ts.codePointAt(i);
            if ((s = s.go(c)).isDead()) {
                return null;
            }
            i += c > 65535 ? 2 : 1;
        }
        return s.isAccepted() ? (A)s.value : null;
    }

    public static class Node<A>
    extends TrieNode<Integer, A> {
        Map<Integer, Node<A>> edges;
        private int nodeNo;
        A value;

        Node(int nodeNo, A value, boolean acc) {
            super(acc);
            this.nodeNo = nodeNo;
            this.value = value;
            this.edges = new HashMap<Integer, Node<A>>();
        }

        private Node(int nodeNo, A value, Map<Integer, Node<A>> e, boolean acc) {
            super(acc);
            this.nodeNo = nodeNo;
            this.value = value;
            this.edges = e;
        }

        @Override
        public A getState() {
            return this.value;
        }

        public Node<A> go(Integer x) {
            return this.goInt(x);
        }

        @Override
        public Node<A> goInt(int x) {
            Node<A> m = this.edges.get(x);
            return m != null ? m : DEADNODE;
        }

        @Override
        public Node<A> goChar(char x) {
            return this.goInt(x);
        }

        @Override
        public DFAState<Integer, A, Void> goBound(TextBound bound) {
            return DFAs.deadState();
        }

        @Override
        public boolean isInitialState() {
            return this.nodeNo == 0;
        }

        @Override
        public boolean isDead() {
            return this.nodeNo < 0;
        }

        @Override
        public Map<Integer, TrieNode<Integer, A>> getEdges() {
            return Collections.unmodifiableMap(this.edges);
        }

        @Override
        public boolean willFail(Integer t) {
            return this.willFail((int)t);
        }

        @Override
        public boolean willFail(int x) {
            return ((Node)this.goInt(x)).isDead();
        }

        @Override
        public boolean willFail(char x) {
            return this.willFail((int)x);
        }

        @Override
        public Set<Integer> getAlphabets() {
            return this.edges.keySet();
        }

        @Override
        public Iterable<Interval> getAlphabetRanges() {
            HashSet<Interval> r = new HashSet<Interval>();
            for (Integer t : this.getAlphabets()) {
                r.add(Interval.newPoint(t));
            }
            return r;
        }
    }
}

