/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.automata.trie;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.morilib.automata.DFAState;
import net.morilib.automata.Homomorphism;
import net.morilib.automata.TextBound;
import net.morilib.automata.dfa.DFAs;
import net.morilib.automata.trie.Trie;
import net.morilib.automata.trie.TrieNode;
import net.morilib.range.Interval;

public class GenericTrie<T, A>
implements Trie<T, A>,
Homomorphism<A, T> {
    static final Node<Object, Object> DEADNODE = new Node(-1, null, false);
    private Node<T, A> init;
    Map<A, List<T>> map;

    GenericTrie() {
        this.init = new Node(0, null, false);
        this.map = new HashMap<A, List<T>>();
    }

    public GenericTrie(GenericTrie<T, A> trie) {
        this.init = GenericTrie.copytrie(trie.init);
        this.map = new HashMap<A, List<T>>(trie.map);
    }

    private static <T, A> Node<T, A> copytrie(Node<T, A> n) {
        HashMap e = new HashMap();
        for (Object i : n.edges.keySet()) {
            e.put(i, GenericTrie.copytrie(n.edges.get(i)));
        }
        return new Node(((Node)n).nodeNo, n.value, e, n.isAccepted());
    }

    @Override
    public Node<T, A> getInitialState() {
        return this.init;
    }

    @Override
    public List<T> get(A a) {
        return this.map.get(a);
    }

    @Override
    public A invert(List<T> ts) {
        DFAState s = this.init;
        for (T t : ts) {
            if (!(s = s.go((Object)t)).isDead()) continue;
            return null;
        }
        return s.isAccepted() ? (A)s.value : null;
    }

    @Override
    public A invert(T ... ts) {
        return this.invert(Arrays.asList(ts));
    }

    public static class Node<T, A>
    extends TrieNode<T, A> {
        Map<T, Node<T, A>> edges;
        A value;
        private int nodeNo;

        Node(int nodeNo, A value, boolean acc) {
            super(acc);
            this.nodeNo = nodeNo;
            this.value = value;
            this.edges = new HashMap<T, Node<T, A>>();
        }

        private Node(int nodeNo, A value, Map<T, Node<T, A>> e, boolean acc) {
            super(acc);
            this.nodeNo = nodeNo;
            this.value = value;
            this.edges = e;
        }

        @Override
        public A getState() {
            return this.value;
        }

        @Override
        public Node<T, A> go(T x) {
            Node<T, A> m = this.edges.get(x);
            return m != null ? m : DEADNODE;
        }

        @Override
        public DFAState<T, A, Void> goBound(TextBound bound) {
            return DFAs.deadState();
        }

        @Override
        public boolean isInitialState() {
            return this.nodeNo == 0;
        }

        @Override
        public boolean isDead() {
            return this.nodeNo < 0;
        }

        @Override
        public Map<T, TrieNode<T, A>> getEdges() {
            return Collections.unmodifiableMap(this.edges);
        }

        @Override
        public boolean willFail(T t) {
            return ((Node)this.go((Object)t)).isDead();
        }

        @Override
        public Set<T> getAlphabets() {
            return this.edges.keySet();
        }

        @Override
        public Iterable<Interval> getAlphabetRanges() {
            HashSet<Interval> r = new HashSet<Interval>();
            for (T t : this.getAlphabets()) {
                r.add(Interval.newPoint(t));
            }
            return r;
        }
    }
}

