/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.automata.nfa;

import java.util.Set;
import net.morilib.automata.NFAState;
import net.morilib.automata.nfa.NFAObject;
import net.morilib.automata.nfa.NFAs;

public final class StringNFAMatcher<A> {
    private NFAObject<Integer, A, ?> nfa;
    private Set<A> result = null;
    private String matched = null;

    public StringNFAMatcher(NFAObject<Integer, A, ?> nfa) {
        this.nfa = nfa;
    }

    private Set<NFAState> getInitialStates() {
        return NFAs.getEpsilonReachable(this.nfa, this.nfa.getInitialStates());
    }

    public boolean match(String str) {
        Set<NFAState> s;
        StringBuilder matches = new StringBuilder();
        Set<NFAState> t = s = this.getInitialStates();
        int i = 0;
        while (i < str.length()) {
            char a = str.charAt(i);
            matches.append(a);
            t = NFAs.getStates(this.nfa, s, Integer.valueOf(a));
            s = NFAs.getEpsilonReachable(this.nfa, t);
            if (s.isEmpty()) {
                return false;
            }
            ++i;
        }
        if (this.nfa.isFinalAny(s)) {
            this.matched = matches.toString();
            this.result = NFAs.getAccept(this.nfa, s);
            return true;
        }
        this.matched = null;
        this.result = null;
        return false;
    }

    public Set<A> getResult() {
        return this.result;
    }

    public String getMatched() {
        return this.matched;
    }
}

