/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.automata.dfa;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import net.morilib.automata.CharSequenceHead;
import net.morilib.automata.DFA;
import net.morilib.automata.DFAState;
import net.morilib.automata.TextBound;
import net.morilib.automata.regular.AlternativeBasicRegex;
import net.morilib.automata.regular.BasicRegex;
import net.morilib.automata.regular.BasicRegexUtils;
import net.morilib.automata.regular.ConcatenateBasicRegex;
import net.morilib.automata.regular.ObjectBasicRegex;
import net.morilib.automata.regular.StarClosureBasicRegex;
import net.morilib.range.Interval;
import net.morilib.util.iterator.LookaheadIterator;
import net.morilib.util.iterator.WrappedLookaheadIterator;
import net.morilib.util.set.PairSet;

public final class DFAs {
    public static final DFAState<Object, Object, Object> DEAD_STATE = new DFAState<Object, Object, Object>(){

        @Override
        public Set<Object> getAccepted() {
            return Collections.emptySet();
        }

        @Override
        public DFAState<Object, Object, Object> go(Object a) {
            return this;
        }

        @Override
        public DFAState<Object, Object, Object> goBound(TextBound a) {
            return this;
        }

        @Override
        public boolean isInitialState() {
            return false;
        }

        @Override
        public boolean isDead() {
            return true;
        }

        @Override
        public DFAState<Object, Object, Object> goInt(int x) {
            return this;
        }

        @Override
        public DFAState<Object, Object, Object> goChar(char x) {
            return this;
        }

        @Override
        public boolean isAccepted() {
            return false;
        }

        @Override
        public Set<Object> getAlphabets() {
            return Collections.emptySet();
        }

        @Override
        public Iterable<Interval> getAlphabetRanges() {
            return Collections.emptySet();
        }
    };

    private DFAs() {
    }

    public static <T, A, B> DFAState<T, A, B> deadState() {
        return DEAD_STATE;
    }

    public static <A, B> Set<A> input(DFAState<Integer, A, B> st, CharSequenceHead seq) {
        DFAState<Integer, A, B> s3;
        DFAState<Integer, A, B> s2 = st;
        while (seq.hasNext()) {
            s3 = s2;
            EnumSet<TextBound> bs = seq.getBounds();
            int c = seq.readInt();
            while ((s2 = s2.goInt(c)).isDead()) {
                for (TextBound b : bs) {
                    s2 = s3.goBound(b);
                    if (s2.isDead()) continue;
                    s3 = s2;
                    break;
                }
                if (!s2.isDead()) continue;
                return Collections.emptySet();
            }
        }
        block3: while (true) {
            s3 = s2;
            for (TextBound b : seq.getBounds()) {
                s3 = s2.goBound(b);
                if (s3.isDead()) continue;
                s2 = s3;
                continue block3;
            }
            break;
        }
        return s2.getAccepted();
    }

    public static <A, B> Set<A> input(DFAState<Integer, A, B> st, CharSequence seq) {
        return DFAs.input(st, new CharSequenceHead(seq));
    }

    public static <A, B> Set<A> input(DFA<Integer, A, B> dfa, CharSequenceHead seq) {
        return DFAs.input(dfa.getInitialState(), seq);
    }

    public static <A, B> Set<A> input(DFA<Integer, A, B> dfa, CharSequence seq) {
        return DFAs.input(dfa, new CharSequenceHead(seq));
    }

    public static <A, B> Set<A> match(DFAState<Integer, A, B> st, CharSequenceHead seq) {
        DFAState<Integer, A, B> s3;
        DFAState<Integer, A, B> s2 = st;
        while (seq.hasNext()) {
            s3 = s2;
            EnumSet<TextBound> bs = seq.getBounds();
            int c = seq.readInt();
            while ((s2 = s2.goInt(c)).isDead()) {
                for (TextBound b : bs) {
                    s2 = s3.goBound(b);
                    if (s2.isDead()) continue;
                    s3 = s2;
                    break;
                }
                if (!s2.isDead()) continue;
                seq.unread();
                return s3.getAccepted();
            }
        }
        block3: while (true) {
            s3 = s2;
            for (TextBound b : seq.getBounds()) {
                s3 = s2.goBound(b);
                if (s3.isDead()) continue;
                s2 = s3;
                continue block3;
            }
            break;
        }
        return s2.getAccepted();
    }

    public static <A, B> Set<A> match(DFAState<Integer, A, B> st, CharSequence seq) {
        return DFAs.match(st, new CharSequenceHead(seq));
    }

    public static <A, B> Set<A> match(DFA<Integer, A, B> dfa, CharSequenceHead seq) {
        return DFAs.match(dfa.getInitialState(), seq);
    }

    public static <A, B> Set<A> match(DFA<Integer, A, B> dfa, CharSequence seq) {
        return DFAs.match(dfa, new CharSequenceHead(seq));
    }

    public static <A, B> boolean isMatched(DFAState<Integer, A, B> st, CharSequenceHead seq) {
        return !DFAs.match(st, seq).isEmpty();
    }

    public static <A, B> boolean isMatched(DFAState<Integer, A, B> st, CharSequence seq) {
        return DFAs.isMatched(st, new CharSequenceHead(seq));
    }

    public static <A, B> boolean isMatched(DFA<Integer, A, B> dfa, CharSequenceHead seq) {
        return DFAs.isMatched(dfa.getInitialState(), seq);
    }

    public static <A, B> boolean isMatched(DFA<Integer, A, B> dfa, CharSequence seq) {
        return DFAs.isMatched(dfa, new CharSequenceHead(seq));
    }

    public static <T, A> Set<A> match(DFAState<T, A, ?> st, LookaheadIterator<T> seq) {
        DFAState<T, A, ?> s2 = st;
        while (seq.hasNext()) {
            DFAState<T, A, ?> s3 = s2;
            T c = seq.peek();
            if ((s2 = s2.go(c)).isDead()) {
                return s3.getAccepted();
            }
            seq.next();
        }
        return s2.getAccepted();
    }

    public static <T, A> Set<A> match(DFAState<T, A, ?> st, Collection<T> seq) {
        return DFAs.match(st, new WrappedLookaheadIterator<T>(seq.iterator()));
    }

    public static <T, A> Set<A> match(DFAState<T, A, ?> st, T ... seq) {
        return DFAs.match(st, Arrays.asList(seq));
    }

    public static <T, A> Set<A> match(DFA<T, A, ?> dfa, LookaheadIterator<T> seq) {
        return DFAs.match(dfa.getInitialState(), seq);
    }

    public static <T, A> Set<A> match(DFA<T, A, ?> dfa, Collection<T> seq) {
        return DFAs.match(dfa.getInitialState(), seq);
    }

    public static <T, A> Set<A> match(DFA<T, A, ?> dfa, T ... seq) {
        return DFAs.match(dfa.getInitialState(), seq);
    }

    public static <T, A> boolean isMatched(DFAState<T, A, ?> st, LookaheadIterator<T> seq) {
        return !DFAs.match(st, seq).isEmpty();
    }

    public static <T, A> boolean isMatched(DFAState<T, A, ?> st, Collection<T> seq) {
        return !DFAs.match(st, seq).isEmpty();
    }

    public static <T, A> boolean isMatched(DFAState<T, A, ?> st, T ... seq) {
        return !DFAs.match(st, seq).isEmpty();
    }

    public static <T, A> boolean isMatched(DFA<T, A, ?> dfa, LookaheadIterator<T> seq) {
        return !DFAs.match(dfa, seq).isEmpty();
    }

    public static <T, A> boolean isMatched(DFA<T, A, ?> dfa, Collection<T> seq) {
        return !DFAs.match(dfa, seq).isEmpty();
    }

    public static <T, A> boolean isMatched(DFA<T, A, ?> dfa, T ... seq) {
        return !DFAs.match(dfa, seq).isEmpty();
    }

    public static <T, A> Set<A> matchAll(DFAState<T, A, ?> st, Iterator<T> seq) {
        DFAState<T, A, ?> s2 = st;
        while (seq.hasNext()) {
            T c = seq.next();
            if (!(s2 = s2.go(c)).isDead()) continue;
            return Collections.emptySet();
        }
        return s2.getAccepted();
    }

    public static <T, A> Set<A> matchAll(DFAState<T, A, ?> st, Collection<T> seq) {
        return DFAs.matchAll(st, seq.iterator());
    }

    public static <T, A> Set<A> matchAll(DFAState<T, A, ?> st, T ... seq) {
        return DFAs.matchAll(st, Arrays.asList(seq));
    }

    public static <T, A> Set<A> matchAll(DFA<T, A, ?> dfa, Iterator<T> seq) {
        return DFAs.matchAll(dfa.getInitialState(), seq);
    }

    public static <T, A> Set<A> matchAll(DFA<T, A, ?> dfa, Collection<T> seq) {
        return DFAs.matchAll(dfa.getInitialState(), seq);
    }

    public static <T, A> Set<A> matchAll(DFA<T, A, ?> dfa, T ... seq) {
        return DFAs.matchAll(dfa.getInitialState(), seq);
    }

    public static <T> boolean isMatchAll(DFAState<T, ?, ?> st, Iterator<T> seq) {
        DFAState<T, ?, ?> s2 = st;
        while (seq.hasNext()) {
            T c = seq.next();
            if (!(s2 = s2.go(c)).isDead()) continue;
            return false;
        }
        return !s2.getAccepted().isEmpty();
    }

    public static <T> boolean isMatchAll(DFAState<T, ?, ?> st, Collection<T> seq) {
        return DFAs.isMatchAll(st, seq.iterator());
    }

    public static <T> boolean isMatchAll(DFAState<T, ?, ?> st, T ... seq) {
        return DFAs.isMatchAll(st, Arrays.asList(seq));
    }

    public static <T> boolean isMatchAll(DFA<T, ?, ?> dfa, Iterator<T> seq) {
        return DFAs.isMatchAll(dfa.getInitialState(), seq);
    }

    public static <T> boolean isMatchAll(DFA<T, ?, ?> dfa, Collection<T> seq) {
        return DFAs.isMatchAll(dfa.getInitialState(), seq);
    }

    public static <T> boolean isMatchAll(DFA<T, ?, ?> dfa, T ... seq) {
        return DFAs.isMatchAll(dfa.getInitialState(), seq);
    }

    public static <T> List<DFAState<T, ?, ?>> allStates(DFA<T, ?, ?> dfa) {
        ArrayList l = new ArrayList();
        l.add(dfa.getInitialState());
        int i = 0;
        while (i < l.size()) {
            for (Object o : ((DFAState)l.get(i)).getAlphabets()) {
                DFAState s = ((DFAState)l.get(i)).go(o);
                if (l.contains(s)) continue;
                l.add(s);
            }
            ++i;
        }
        return l;
    }

    private static <T> void writere(BasicRegex[][][] tbl, List<DFAState<T, ?, ?>> l, int m) {
        int i = 0;
        while (i < tbl[m].length) {
            for (T o : l.get(i).getAlphabets()) {
                int n = l.indexOf(l.get(i).go(o));
                tbl[m][i][n] = tbl[m][i][n] == null ? new ObjectBasicRegex(o) : new AlternativeBasicRegex(new ObjectBasicRegex(o), tbl[m][i][n]);
            }
            ++i;
        }
    }

    public static <T> BasicRegex convertToRegex(DFA<T, ?, ?> dfa) {
        BasicRegex f;
        BasicRegex e;
        int j;
        int i;
        List<DFAState<T, ?, ?>> l = DFAs.allStates(dfa);
        BasicRegex[][][] tbl = new BasicRegex[l.size() + 1][l.size()][l.size()];
        int m = 0;
        while (m < tbl.length) {
            i = 0;
            while (i < tbl[m].length) {
                j = 0;
                while (j < tbl[m][i].length) {
                    tbl[m][i][j] = m == 0 && i == j ? BasicRegexUtils.EPSILON : BasicRegexUtils.NIHIL;
                    ++j;
                }
                ++i;
            }
            ++m;
        }
        m = 0;
        while (m < tbl.length) {
            if (m == 0) {
                DFAs.writere(tbl, l, m);
            } else {
                int k = m - 1;
                i = 0;
                while (i < tbl[m].length) {
                    j = 0;
                    while (j < tbl[m][i].length) {
                        tbl[m][i][j] = tbl[k][i][j];
                        ++j;
                    }
                    ++i;
                }
                i = 0;
                while (i < tbl[m].length) {
                    j = 0;
                    while (j < tbl[m][i].length) {
                        e = tbl[m][i][j];
                        f = tbl[m - 1][i][k];
                        BasicRegex g = tbl[m - 1][k][k];
                        BasicRegex h = tbl[m - 1][k][j];
                        g = new StarClosureBasicRegex(g);
                        f = new ConcatenateBasicRegex(f, g, h);
                        e = new AlternativeBasicRegex(e, f);
                        tbl[m][i][j] = e.simplify();
                        ++j;
                    }
                    ++i;
                }
            }
            ++m;
        }
        e = BasicRegexUtils.NIHIL;
        int i2 = 0;
        while (i2 < l.size()) {
            if (l.get(i2).isAccepted()) {
                f = tbl[tbl.length - 1][0][i2];
                e = new AlternativeBasicRegex(f, e);
            }
            ++i2;
        }
        return e.simplify();
    }

    public static <T> Set<DFAState<T, ?, ?>> getReachableStatesDiscrete(DFA<T, ?, ?> dfa) {
        HashSet s = new HashSet();
        Stack st = new Stack();
        s.add(dfa.getInitialState());
        st.push(dfa.getInitialState());
        while (!st.isEmpty()) {
            DFAState x = (DFAState)st.pop();
            for (Object a : x.getAlphabets()) {
                DFAState y = x.go(a);
                if (y.isDead() || s.contains(y)) continue;
                s.add(y);
                st.push(y);
            }
        }
        return s;
    }

    public static <T> boolean isEmptyDiscrete(DFA<T, ?, ?> dfa) {
        Set<DFAState<T, ?, ?>> s = DFAs.getReachableStatesDiscrete(dfa);
        for (DFAState<T, ?, ?> t : s) {
            if (!t.isAccepted()) continue;
            return false;
        }
        return true;
    }

    private static <T> boolean finddist(Set<PairSet<DFAState<T, ?, ?>>> st, DFAState<T, ?, ?> a, DFAState<T, ?, ?> b) {
        if (a.isDead() && b.isDead()) {
            return false;
        }
        if (a.isDead() || b.isDead()) {
            return true;
        }
        if (a.equals(b)) {
            return false;
        }
        for (PairSet<DFAState<T, ?, ?>> p : st) {
            if (!p.isPair(a, b)) continue;
            return false;
        }
        return true;
    }

    static <T> Set<PairSet<DFAState<T, ?, ?>>> fillTable(List<DFAState<T, ?, ?>> l) {
        boolean dirty = true;
        HashSet r = new HashSet();
        int i = 0;
        while (i < l.size()) {
            int j = i + 1;
            while (j < l.size()) {
                if (l.get(i).isAccepted() == l.get(j).isAccepted()) {
                    r.add(new PairSet(l.get(i), l.get(j)));
                }
                ++j;
            }
            ++i;
        }
        while (dirty) {
            dirty = false;
            HashSet s = new HashSet(r);
            Iterator itr = s.iterator();
            while (itr.hasNext()) {
                boolean f = false;
                PairSet p = (PairSet)itr.next();
                DFAState a = (DFAState)p.get1();
                DFAState b = (DFAState)p.get2();
                for (Object t : a.getAlphabets()) {
                    f |= DFAs.finddist(r, a.go(t), b.go(t));
                }
                for (Object t : b.getAlphabets()) {
                    f |= DFAs.finddist(r, a.go(t), b.go(t));
                }
                if (!f) continue;
                itr.remove();
                dirty = true;
            }
            r = new HashSet(s);
        }
        return r;
    }

    public static <T> Set<PairSet<DFAState<T, ?, ?>>> getEquivalentStatesDiscrete(DFA<T, ?, ?> dfa) {
        ArrayList l = new ArrayList(DFAs.getReachableStatesDiscrete(dfa));
        return DFAs.fillTable(l);
    }

    public static <T> boolean isEquivalentDiscrete(DFA<T, ?, ?> dfa1, DFA<T, ?, ?> dfa2) {
        if (dfa1.equals(dfa2)) {
            return true;
        }
        if (DFAs.isEmptyDiscrete(dfa1)) {
            return DFAs.isEmptyDiscrete(dfa2);
        }
        if (DFAs.isEmptyDiscrete(dfa2)) {
            return false;
        }
        ArrayList l = new ArrayList();
        Set<DFAState<T, ?, ?>> s = DFAs.getReachableStatesDiscrete(dfa1);
        l.addAll(s);
        Set<DFAState<T, ?, ?>> t = DFAs.getReachableStatesDiscrete(dfa2);
        l.addAll(t);
        Set<PairSet<DFAState<T, ?, ?>>> r = DFAs.fillTable(l);
        for (DFAState<T, ?, ?> x : s) {
            for (PairSet<DFAState<T, ?, ?>> a : r) {
                if (!a.contains(x)) continue;
                t.remove(a.getOpposite(x));
            }
        }
        return t.isEmpty();
    }
}

