/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.arith;

import net.morilib.arith.NonnegativeDegree;
import net.morilib.arith.Signum2;

public class Degree
extends Number
implements Comparable<Degree> {
    public static Degree ZERO = new Degree(Signum2.POSITIVE, NonnegativeDegree.ZERO);
    private Signum2 signum;
    private NonnegativeDegree number;

    Degree(int x) {
        this.signum = x < 0 ? Signum2.NEGATIVE : Signum2.POSITIVE;
        this.number = new NonnegativeDegree(Math.abs(x));
    }

    public Degree(Signum2 signum, NonnegativeDegree abs) {
        this.signum = signum;
        this.number = abs;
    }

    public Degree(int signum, NonnegativeDegree abs) {
        this.signum = Signum2.toSignum(signum);
        this.number = abs;
    }

    public Degree(int degree, int minutes, int seconds, int undersec) {
        if (degree != 0) {
            this.signum = degree < 0 ? Signum2.NEGATIVE : Signum2.POSITIVE;
            this.number = new NonnegativeDegree(Math.abs(degree), minutes, seconds, undersec);
        } else if (minutes != 0) {
            this.signum = minutes < 0 ? Signum2.NEGATIVE : Signum2.POSITIVE;
            this.number = new NonnegativeDegree(0, Math.abs(minutes), seconds, undersec);
        } else if (seconds != 0) {
            this.signum = seconds < 0 ? Signum2.NEGATIVE : Signum2.POSITIVE;
            this.number = new NonnegativeDegree(0, 0, Math.abs(seconds), undersec);
        } else if (undersec != 0) {
            this.signum = undersec < 0 ? Signum2.NEGATIVE : Signum2.POSITIVE;
            this.number = new NonnegativeDegree(0, 0, 0, Math.abs(undersec));
        } else {
            this.signum = Signum2.POSITIVE;
            this.number = NonnegativeDegree.ZERO;
        }
    }

    public static Degree parse(String string) {
        NonnegativeDegree d;
        Signum2 s;
        if (string == null) {
            throw new NullPointerException();
        }
        if (string.length() == 0) {
            throw new NumberFormatException();
        }
        switch (string.charAt(0)) {
            case '+': {
                s = Signum2.POSITIVE;
                d = NonnegativeDegree.parse(string.substring(1));
                break;
            }
            case '-': {
                s = Signum2.NEGATIVE;
                d = NonnegativeDegree.parse(string.substring(1));
                break;
            }
            default: {
                s = Signum2.POSITIVE;
                d = NonnegativeDegree.parse(string);
            }
        }
        return new Degree(s, d);
    }

    public Degree add(Degree x, int[] carry) {
        if (this.signum.equals(x.signum)) {
            NonnegativeDegree z = this.number.add(x.number, carry);
            if (carry != null && carry.length > 0) {
                carry[0] = this.signum.multiply(carry[0]);
            }
            return new Degree(this.signum, z);
        }
        if (this.number.compareTo(x.number) > 0) {
            NonnegativeDegree z = this.number.subtract(x.number);
            if (carry != null && carry.length > 0) {
                carry[0] = 0;
            }
            return new Degree(this.signum, z);
        }
        if (this.number.compareTo(x.number) < 0) {
            NonnegativeDegree z = x.number.subtract(this.number);
            if (carry != null && carry.length > 0) {
                carry[0] = 0;
            }
            return new Degree(x.signum, z);
        }
        return ZERO;
    }

    public Degree add(Degree x) {
        return this.add(x, null);
    }

    public Degree subtract(Degree x, int[] carry) {
        return this.add(x.negate(), carry);
    }

    public Degree subtract(Degree x) {
        return this.subtract(x, null);
    }

    public Degree negate() {
        return new Degree(this.signum.negate(), this.number);
    }

    public Degree multiply(Degree x, int[] carry) {
        return new Degree(this.signum.multiply(x.signum), this.number.multiply(x.number, carry));
    }

    public Degree multiply(Degree x) {
        return this.multiply(x, null);
    }

    public Degree divide(Degree x, int[] carry) {
        return new Degree(this.signum.multiply(x.signum), this.number.divide(x.number, carry));
    }

    public Degree divide(Degree x) {
        return this.divide(x, null);
    }

    public Degree remainder(Degree x) {
        return new Degree(this.signum, this.number.remainder(x.number));
    }

    public Degree invert() {
        return new Degree(this.signum, this.number.invert());
    }

    public Degree abs() {
        return new Degree(Signum2.POSITIVE, this.number);
    }

    public int signum() {
        return this.number.signum() == 0 ? 0 : this.signum.signum();
    }

    @Override
    public int intValue() {
        return this.signum.multiply(this.number.intValue());
    }

    @Override
    public long longValue() {
        return this.signum.multiply(this.number.longValue());
    }

    @Override
    public float floatValue() {
        return (float)this.doubleValue();
    }

    @Override
    public double doubleValue() {
        return this.signum.multiply(this.number.doubleValue());
    }

    @Override
    public int compareTo(Degree o) {
        int c = this.signum.compareTo(o.signum);
        return c != 0 ? c : this.number.compareTo(o.number);
    }

    public int hashCode() {
        return this.signum.multiply(this.number.hashCode());
    }

    public boolean equals(Object o) {
        if (!(o instanceof Degree)) {
            return false;
        }
        Degree d = (Degree)o;
        if (d.signum() == 0 && this.signum() == 0) {
            return true;
        }
        if (!this.signum.equals(d.signum)) {
            return false;
        }
        return this.number.equals(d.number);
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        if (this.signum.signum() < 0) {
            b.append("-");
        }
        b.append(this.number.toString());
        return b.toString();
    }
}

