/*
 * Copyright 2009 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.lisp.lite.subr;

import net.morilib.lisp.lite.Datum;
import net.morilib.lisp.lite.Environment;
import net.morilib.lisp.lite.LispBoolean;
import net.morilib.lisp.lite.LispInteger;
import net.morilib.lisp.lite.LispMessage;
import net.morilib.lisp.lite.LispReal;

public class IsPositive extends UnaryArgs {

	@Override
	protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
		if(c1a instanceof LispReal) {
			LispReal n = (LispReal)c1a;
			
			return LispBoolean.getInstance(
					n.isMoreThan(LispInteger.ZERO));
		}
		throw mesg.getError("err.require.real", c1a);
		//throw new LispException("real number required");
	}

}
