/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.lite.subr;

import java.util.List;
import net.morilib.lisp.lite.Datum;
import net.morilib.lisp.lite.Environment;
import net.morilib.lisp.lite.LispBoolean;
import net.morilib.lisp.lite.LispMessage;
import net.morilib.lisp.lite.LispNumber;
import net.morilib.lisp.lite.LispString;
import net.morilib.lisp.lite.LispUtils;
import net.morilib.lisp.lite.Subr;
import net.morilib.lisp.lite.subr.SubrUtils;

public class StringToNumber
extends Subr {
    private Datum process(Datum d, int radix, LispMessage mesg) {
        if (d instanceof LispString) {
            LispNumber n = LispNumber.parse(((LispString)d).getString(), radix);
            return n != null ? n : LispBoolean.FALSE;
        }
        throw mesg.getError("err.require.string", d);
    }

    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        List<Datum> lst = LispUtils.consToList(body, mesg);
        if (lst.size() == 1) {
            return this.process(lst.get(0), 10, mesg);
        }
        if (lst.size() == 2) {
            Datum d = lst.get(1);
            if (d instanceof LispNumber) {
                LispNumber n = (LispNumber)d;
                if (!n.isInteger()) {
                    throw mesg.getError("err.require.smallint", n);
                }
                int ii = SubrUtils.getSmallInt(n, mesg);
                if (ii < 2 || ii > 16) {
                    throw mesg.getError("err.radix.invalid");
                }
                return this.process(lst.get(0), ii, mesg);
            }
            throw mesg.getError("err.require.smallint", d);
        }
        throw mesg.getError("err.argument", this.symbolName);
    }
}

