/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.lite.subr;

import net.morilib.lisp.lite.ConsIterator;
import net.morilib.lisp.lite.Datum;
import net.morilib.lisp.lite.Environment;
import net.morilib.lisp.lite.LispBoolean;
import net.morilib.lisp.lite.LispMessage;
import net.morilib.lisp.lite.LispNumber;
import net.morilib.lisp.lite.Nil;
import net.morilib.lisp.lite.Subr;
import net.morilib.lisp.lite.subr.SubrUtils;

public class NumEqual
extends Subr {
    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        ConsIterator itr = new ConsIterator(body);
        LispNumber p = null;
        Datum d = Nil.NIL;
        while (itr.hasNext()) {
            try {
                d = itr.next();
                if (!(d instanceof LispNumber)) {
                    throw mesg.getError("err.require.number", d);
                }
                if (p != null && !p.isEqualTo((LispNumber)d)) {
                    return LispBoolean.FALSE;
                }
                p = (LispNumber)d;
            }
            catch (ClassCastException e) {
                throw mesg.getError("err.math.mismatch", d);
            }
        }
        SubrUtils.checkTerminated(itr, body, mesg);
        return LispBoolean.TRUE;
    }

    @Override
    public String toString() {
        return "Subr:=";
    }
}

