/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.lite.subr;

import net.morilib.lisp.lite.Cons;
import net.morilib.lisp.lite.Datum;
import net.morilib.lisp.lite.Environment;
import net.morilib.lisp.lite.LispInteger;
import net.morilib.lisp.lite.LispMessage;
import net.morilib.lisp.lite.LispNumber;
import net.morilib.lisp.lite.Nil;
import net.morilib.lisp.lite.subr.MathOperator1;

public class Mul
extends MathOperator1 {
    @Override
    protected LispNumber calculate(LispNumber o1, LispNumber o2) {
        return o1.mul(o2);
    }

    @Override
    protected LispNumber initValue() {
        return LispInteger.ONE;
    }

    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        LispNumber res = LispInteger.ONE;
        LispNumber re2 = LispInteger.ONE;
        Datum li = body;
        while (true) {
            if (li instanceof Nil) {
                return re2;
            }
            if (!(li instanceof Cons)) break;
            Cons c2 = (Cons)li;
            Datum c2a = c2.getCar();
            if (!(c2a instanceof LispNumber)) {
                throw mesg.getError("err.require.number", c2a);
            }
            if (re2 != null && c2a instanceof LispNumber) {
                re2 = ((LispNumber)re2).mul((LispNumber)c2a);
            } else {
                if (res != null && res instanceof LispNumber && c2a instanceof LispNumber) {
                    try {
                        re2 = ((LispNumber)c2a).mul(res);
                        res = null;
                    }
                    catch (ClassCastException e) {
                        throw mesg.getError("err.math.invalid.scalar", c2a);
                    }
                    catch (IllegalArgumentException e) {
                        throw mesg.getError("err.math.invalid.scalar", c2a);
                    }
                }
                try {
                    res = this.calculate(res, (LispNumber)c2a);
                }
                catch (ClassCastException e) {
                    throw mesg.getError("err.math.require.sametype", c2a);
                }
            }
            li = c2.getCdr();
        }
        throw mesg.getError("err.list");
    }
}

