/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.lite.subr;

import java.util.List;
import net.morilib.lisp.lite.Datum;
import net.morilib.lisp.lite.Environment;
import net.morilib.lisp.lite.LispMessage;
import net.morilib.lisp.lite.LispString;
import net.morilib.lisp.lite.LispUtils;
import net.morilib.lisp.lite.Subr;
import net.morilib.lisp.lite.subr.SubrUtils;

public class MakeString
extends Subr {
    private String makeString(int len, char ch) {
        StringBuilder b = new StringBuilder();
        int i = 0;
        while (i < len) {
            b.append(ch);
            ++i;
        }
        return b.toString();
    }

    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        List<Datum> lst = LispUtils.consToList(body, mesg);
        if (lst.size() == 1) {
            int t = SubrUtils.getSmallInt(lst.get(0), mesg);
            if (t < 0) {
                throw mesg.getError("err.require.int.nonnegative", lst.get(0));
            }
            return new LispString(this.makeString(t, ' '));
        }
        if (lst.size() == 2) {
            int t = SubrUtils.getSmallInt(lst.get(0), mesg);
            char ch = SubrUtils.getCharacter(lst.get(1), mesg);
            if (t < 0) {
                throw mesg.getError("err.require.int.nonnegative", lst.get(0));
            }
            return new LispString(this.makeString(t, ch));
        }
        throw mesg.getError("err.argument", this.symbolName);
    }
}

