/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.lite.subr;

import net.morilib.lisp.lite.Datum;
import net.morilib.lisp.lite.Environment;
import net.morilib.lisp.lite.LispDouble;
import net.morilib.lisp.lite.LispMessage;
import net.morilib.lisp.lite.LispNumber;
import net.morilib.lisp.lite.LispReal;
import net.morilib.lisp.lite.subr.UnaryArgs;

public class Magnitude
extends UnaryArgs {
    @Override
    protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
        if (c1a instanceof LispNumber) {
            LispNumber n = (LispNumber)c1a;
            if (n.isReal()) {
                LispReal r = (LispReal)n;
                return r.signum() < 0 ? r.uminus() : r;
            }
            double r = n.getRealDouble();
            double i = n.getImagDouble();
            return new LispDouble(Math.hypot(r, i));
        }
        throw mesg.getError("err.require.number", c1a);
    }
}

